/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.db;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.homelinux.elabor.db.ConnectionHandler;
import org.homelinux.elabor.db.DataAccessException;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.db.DbmsType;
import org.homelinux.elabor.db.DuplicateKeyException;
import org.homelinux.elabor.db.LoggingDao;
import org.homelinux.elabor.db.MultiExceptionHandler;
import org.homelinux.elabor.db.MultiUpdateHandler;
import org.homelinux.elabor.db.MultipleRowException;
import org.homelinux.elabor.db.NotDeletableException;
import org.homelinux.elabor.db.QueryTemplate;
import org.homelinux.elabor.db.RecordCreator;
import org.homelinux.elabor.db.StringCreator;
import org.homelinux.elabor.exceptions.UnrecoverableException;
import org.homelinux.elabor.structures.KeyRecord;
import org.homelinux.elabor.structures.classifier.RecordClassifier;
import org.homelinux.elabor.structures.extractors.KeyExtractor;
import org.homelinux.elabor.structures.safe.SafeMap;

public class ConnectionManager
implements ConnectionHandler,
LoggingDao {
    private Connection connection;
    private String host;
    private String dbUser;
    private String dbName;
    private String dbPass;
    private DbmsType dbmsType;
    private Logger logger;

    public ConnectionManager(String host, DbmsType dbmsType, String dbName, String dbUser, String dbPass, boolean connect) {
        this.host = host;
        this.dbmsType = dbmsType;
        this.dbUser = dbUser;
        this.dbName = dbName;
        this.dbPass = dbPass;
        this.logger = Logger.getLogger(this.getClass().getName());
        if (connect) {
            this.initConnection();
        }
    }

    public ConnectionManager(String host, DbmsType dbmsType, String dbName, String dbUser, String dbPass) {
        this(host, dbmsType, dbName, dbUser, dbPass, true);
    }

    public ConnectionManager(DbmsType type, String dbName, String dbUser, String dbPass, boolean connect) {
        this("localhost", type, dbName, dbUser, dbPass, connect);
    }

    public ConnectionManager(DbmsType type, String dbName, String dbUser, String dbPass) {
        this("localhost", type, dbName, dbUser, dbPass);
    }

    public synchronized void initConnection() {
        if (this.connection == null) {
            try {
                this.connection = this.dbmsType.getConnection(this.host, this.dbName, this.dbUser, this.dbPass);
            }
            catch (SQLException e2) {
                throw new DataAccessException(e2);
            }
            catch (ClassNotFoundException e3) {
                throw new DataAccessException(e3);
            }
        }
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void ensureAutocommit() {
        if (this.rollback()) {
            throw new RuntimeException("database not in autocommit mode");
        }
    }

    public void setAutoCommit(boolean autoCommit) {
        try {
            this.connection.setAutoCommit(autoCommit);
        }
        catch (SQLException e2) {
            throw new DataAccessException(e2);
        }
    }

    public void setTransactionIsolation(int transactionIsolation) {
        try {
            this.connection.setTransactionIsolation(transactionIsolation);
        }
        catch (SQLException e2) {
            throw new DataAccessException(e2);
        }
    }

    public boolean rollback() {
        boolean rollbacked = false;
        try {
            if (!this.connection.getAutoCommit()) {
                this.connection.rollback();
                rollbacked = true;
                this.setAutoCommit(true);
            }
        }
        catch (SQLException e2) {
            throw new DataAccessException(e2);
        }
        return rollbacked;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    public ResultSet executeQuery(QueryTemplate query, Statement statement) {
        String queryString = query.toString();
        return this.executeQuery(queryString, statement);
    }

    @Override
    public ResultSet executeQuery(String query, Statement statement) {
        ResultSet result;
        try {
            result = statement.executeQuery(query);
        }
        catch (SQLException e2) {
            throw new DataAccessException(e2, query);
        }
        return result;
    }

    public void execute(List<String> queries) {
        try {
            this.executeMultiple(queries);
        }
        catch (SQLException e2) {
            throw new DataAccessException(e2);
        }
    }

    private void executeMultiple(List<String> queries) throws SQLException {
        boolean autoCommit = this.connection.getAutoCommit();
        this.connection.setAutoCommit(false);
        Savepoint savepoint = this.connection.setSavepoint();
        try {
            try {
                Throwable throwable = null;
                Object var5_8 = null;
                try (Statement statement = this.connection.createStatement();){
                    for (String query : queries) {
                        ConnectionManager.executeSingle(query, statement);
                    }
                    this.connection.commit();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException exc) {
                this.connection.rollback(savepoint);
                throw exc;
            }
            catch (RuntimeException exc) {
                this.connection.rollback(savepoint);
                throw exc;
            }
        }
        finally {
            this.setAutoCommit(autoCommit);
        }
    }

    public void execute(QueryTemplate query) {
        this.execute(query.toString());
    }

    public void execute(String query) {
        try {
            this.executeSingle(query);
        }
        catch (SQLException e2) {
            throw new DataAccessException(e2, query);
        }
    }

    private void executeSingle(String query) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement statement = this.connection.createStatement();){
            ConnectionManager.executeSingle(query, statement);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void executeSingle(String query, Statement statement) {
        try {
            statement.execute(query);
        }
        catch (SQLException e2) {
            throw new DataAccessException(e2, query);
        }
    }

    public void executeUpdateNoControl(QueryTemplate query) {
        String queryString = query.toString();
        this.executeUpdateNoControl(queryString);
    }

    public void executeUpdateNoControl(String query) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement statement = this.connection.createStatement();){
                statement.executeUpdate(query);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e2) {
            throw new DataAccessException(e2, query);
        }
    }

    public void executeDelete(QueryTemplate query) throws NotDeletableException {
        String queryString = query.toString();
        this.executeDelete(queryString);
    }

    public void executeDelete(String query) throws NotDeletableException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement statement = this.connection.createStatement();){
                statement.executeUpdate(query);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e2) {
            String message = e2.getMessage();
            throw new NotDeletableException(message);
        }
    }

    public void executeInsert(QueryTemplate query) throws DuplicateKeyException {
        this.executeInsert(query.toString());
    }

    public void executeInsert(String query) throws DuplicateKeyException {
        try {
            this.execute(query);
        }
        catch (DataAccessException exc) {
            Throwable cause = exc.getCause();
            String message = exc.getMessage();
            if (cause != null && (cause instanceof SQLIntegrityConstraintViolationException || message.contains("ORA-00001") || message.contains("duplicate key"))) {
                throw new DuplicateKeyException(message);
            }
            throw exc;
        }
    }

    public void executeUpdate(QueryTemplate query) throws DataNotFoundException, DuplicateKeyException {
        String string = query.toString();
        this.executeUpdate(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeUpdate(String query) throws DataNotFoundException, DuplicateKeyException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement statement = this.connection.createStatement();){
                int result = statement.executeUpdate(query);
                switch (result) {
                    case 1: {
                        return;
                    }
                    case 0: {
                        throw new DataNotFoundException(query);
                    }
                    default: {
                        throw new DataAccessException("modificati " + result + " record per: " + query);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                } else {
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e2) {
            String message = e2.getMessage();
            throw new DuplicateKeyException(message);
        }
    }

    public boolean queryForExistence(QueryTemplate query) {
        String queryString = query.toString();
        return this.queryForExistence(queryString);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean queryForExistence(String queryString) {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try {
                boolean exists;
                Statement statement = this.connection.createStatement();
                try {
                    try (ResultSet rs = this.executeQuery(queryString, statement);){
                        exists = rs.next();
                    }
                    if (statement == null) return exists;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (statement == null) throw throwable;
                    statement.close();
                    throw throwable;
                }
                statement.close();
                return exists;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException e2) {
            throw new DataAccessException(e2);
        }
    }

    public List<String> getStrings(QueryTemplate query, String fieldName) {
        StringCreator creator = new StringCreator(fieldName);
        return this.getRecords(query, creator);
    }

    public int queryForInt(QueryTemplate query) throws DataNotFoundException {
        return this.queryForInt(query.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int queryForInt(String query) throws DataNotFoundException {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try {
                int num;
                Statement statement = this.connection.createStatement();
                try {
                    try (ResultSet rs = this.executeQuery(query, statement);){
                        if (!rs.next()) throw new DataNotFoundException(query);
                        num = rs.getInt(1);
                        if (rs.next()) {
                            throw new DataAccessException("too many rows for: " + query);
                        }
                    }
                    if (statement == null) return num;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (statement == null) throw throwable;
                    statement.close();
                    throw throwable;
                }
                statement.close();
                return num;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException e2) {
            throw new DataAccessException(e2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double queryForDouble(QueryTemplate query) throws DataNotFoundException {
        try {
            Throwable throwable = null;
            Object var5_5 = null;
            try {
                double result;
                Statement statement = this.connection.createStatement();
                try {
                    try (ResultSet rs = this.executeQuery(query, statement);){
                        if (!rs.next()) throw new DataNotFoundException(query.toString());
                        result = rs.getDouble(1);
                        if (rs.next()) {
                            throw new DataAccessException("too many rows for: " + query.toString());
                        }
                    }
                    if (statement == null) return result;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (statement == null) throw throwable;
                    statement.close();
                    throw throwable;
                }
                statement.close();
                return result;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException e2) {
            throw new DataAccessException(e2);
        }
    }

    public <K, T extends KeyRecord<K>> Map<K, T> getMap(QueryTemplate query, RecordCreator<T> creator) {
        LinkedHashMap map = new LinkedHashMap();
        return this.buildMap(map, query, creator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <K, T> Map<K, T> buildMap(Map<K, T> map, QueryTemplate query, RecordCreator<T> creator, KeyExtractor<K, T> extractor) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                Statement statement = this.connection.createStatement(1004, 1008);
                try {
                    block18: {
                        ResultSet rs = this.executeQuery(query, statement);
                        while (true) {
                            if (!rs.next()) break block18;
                            try {
                                T record = creator.createRecord(rs);
                                if (record == null) continue;
                                K key = extractor.getKey(record);
                                map.put(key, record);
                            }
                            catch (SQLException exc) {
                                this.logSQLExceptionData(exc, rs);
                                throw exc;
                            }
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    if (statement == null) return map;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (statement == null) throw throwable;
                    statement.close();
                    throw throwable;
                }
                statement.close();
                return map;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e2) {
            throw new DataAccessException(e2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <K, T extends KeyRecord<K>> Map<K, T> buildMap(Map<K, T> map, QueryTemplate query, RecordCreator<T> creator) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                Statement statement = this.connection.createStatement(1004, 1008);
                try {
                    block18: {
                        ResultSet rs = this.executeQuery(query, statement);
                        while (true) {
                            if (!rs.next()) break block18;
                            try {
                                KeyRecord record = (KeyRecord)creator.createRecord(rs);
                                if (record == null) continue;
                                Object key = record.getKey();
                                map.put(key, record);
                            }
                            catch (SQLException exc) {
                                this.logSQLExceptionData(exc, rs);
                                throw exc;
                            }
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    if (statement == null) return map;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (statement == null) throw throwable;
                    statement.close();
                    throw throwable;
                }
                statement.close();
                return map;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e2) {
            throw new DataAccessException(e2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <K, T extends KeyRecord<K>> SafeMap<K, T> buildMap(SafeMap<K, T> map, QueryTemplate query, RecordCreator<T> creator) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                Statement statement = this.connection.createStatement(1004, 1008);
                try {
                    block18: {
                        ResultSet rs = this.executeQuery(query, statement);
                        while (true) {
                            if (!rs.next()) break block18;
                            try {
                                KeyRecord record = (KeyRecord)creator.createRecord(rs);
                                if (record == null) continue;
                                Object key = record.getKey();
                                map.add(key, record);
                            }
                            catch (SQLException exc) {
                                this.logSQLExceptionData(exc, rs);
                                throw exc;
                            }
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    if (statement == null) return map;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (statement == null) throw throwable;
                    statement.close();
                    throw throwable;
                }
                statement.close();
                return map;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e2) {
            throw new DataAccessException(e2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <K, V extends KeyRecord<K>, A> void buildClassifier(RecordClassifier<K, V, A> classifier, QueryTemplate query, RecordCreator<? extends V> creator) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                Statement statement = this.connection.createStatement(1004, 1008);
                try {
                    try (ResultSet rs = this.executeQuery(query, statement);){
                        long count = 0L;
                        while (rs.next()) {
                            try {
                                KeyRecord record = (KeyRecord)creator.createRecord(rs);
                                if (record != null) {
                                    classifier.add(record);
                                }
                                if (++count % 10000L != 0L) continue;
                                this.logger.info("connection manager " + count);
                            }
                            catch (SQLException exc) {
                                this.logSQLExceptionData(exc, rs);
                                throw exc;
                            }
                        }
                    }
                    if (statement == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (statement == null) throw throwable;
                    statement.close();
                    throw throwable;
                }
                statement.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException e2) {
            throw new DataAccessException(e2);
        }
    }

    public <T> List<T> getRecords(String query, RecordCreator<T> creator, int limit) {
        ArrayList list = new ArrayList();
        this.addRecords(query, creator, list, limit);
        return list;
    }

    public <T> List<T> getRecords(String query, RecordCreator<T> creator) {
        ArrayList list = new ArrayList();
        this.addRecords(query, creator, list, Integer.MAX_VALUE);
        return list;
    }

    public <T> Set<T> getSet(String query, RecordCreator<T> creator, int limit) {
        LinkedHashSet set = new LinkedHashSet();
        this.addRecords(query, creator, set, limit);
        return set;
    }

    public <T> Set<T> getSet(String query, RecordCreator<T> creator) {
        LinkedHashSet set = new LinkedHashSet();
        this.addRecords(query, creator, set, Integer.MAX_VALUE);
        return set;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> void addRecords(String query, RecordCreator<T> creator, Collection<T> list, int limit) {
        long start = System.currentTimeMillis();
        try {
            Throwable throwable = null;
            Object var10_9 = null;
            try {
                Statement statement = this.connection.createStatement(1004, 1008);
                try {
                    try (ResultSet rs = this.executeQuery(query, statement);){
                        long time = System.currentTimeMillis();
                        this.logger.log(Level.FINE, "statement: " + (time - start));
                        start = time;
                        try {
                            time = System.currentTimeMillis();
                            this.logger.log(Level.FINE, "execute: " + (time - start));
                            start = time;
                            while (rs.next() && list.size() < limit) {
                                try {
                                    T record = creator.createRecord(rs);
                                    if (record != null) {
                                        list.add(record);
                                    }
                                    if (list.size() % 10000 != 0) continue;
                                    this.logger.info("connection manager " + list.size() + "/" + limit);
                                }
                                catch (SQLException exc) {
                                    this.logSQLExceptionData(exc, rs);
                                    throw exc;
                                }
                            }
                            time = System.currentTimeMillis();
                            this.logger.log(Level.FINE, "fetch: " + (time - start));
                            start = time;
                        }
                        finally {
                            time = System.currentTimeMillis();
                            this.logger.log(Level.FINE, "close: " + (time - start));
                        }
                    }
                    if (statement == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (statement == null) throw throwable;
                    statement.close();
                    throw throwable;
                }
                statement.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException e2) {
            throw new DataAccessException(e2);
        }
    }

    public <T> List<T> getRecords(QueryTemplate query, RecordCreator<T> creator) {
        return this.getRecords(query.toString(), creator);
    }

    public <T> List<T> getRecords(QueryTemplate query, RecordCreator<T> creator, int limit) {
        return this.getRecords(query.toString(), creator, limit);
    }

    public <T> Set<T> getSet(QueryTemplate query, RecordCreator<T> creator) {
        String string = query.toString();
        return this.getSet(string, creator);
    }

    public <T> T getRecord(QueryTemplate template, RecordCreator<T> creator, String message, String key, int error) throws DataNotFoundException, MultipleRowException {
        String query = template.toString();
        return this.getRecord(query, creator, message, key, error, true);
    }

    public <T> T getRecord(String query, RecordCreator<T> creator, String message, String key, int error) throws DataNotFoundException, MultipleRowException {
        return this.getRecord(query, creator, message, key, error, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T getRecord(String query, RecordCreator<T> creator, String message, String key, int error, boolean checkUnique) throws DataNotFoundException, MultipleRowException {
        try {
            Throwable throwable = null;
            Object var9_10 = null;
            try {
                T record;
                Statement statement = this.connection.createStatement(1004, 1008);
                try {
                    try (ResultSet rs = this.executeQuery(query, statement);){
                        if (!rs.next()) throw new DataNotFoundException(message, key, error);
                        try {
                            record = creator.createRecord(rs);
                        }
                        catch (SQLException exc) {
                            this.logSQLExceptionData(exc, rs);
                            throw exc;
                        }
                        if (checkUnique && rs.next()) {
                            throw new MultipleRowException("record non unico: " + query);
                        }
                    }
                    if (statement == null) return record;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (statement == null) throw throwable;
                    statement.close();
                    throw throwable;
                }
                statement.close();
                return record;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException e2) {
            throw new DataAccessException(e2);
        }
    }

    public <T> T getRecord(QueryTemplate query, RecordCreator<T> creator, String message, boolean checkUnique) throws DataNotFoundException, MultipleRowException {
        return this.getRecord(query, creator, message, null, checkUnique);
    }

    public <T> T getRecord(QueryTemplate query, RecordCreator<T> creator, String message, String key, boolean checkUnique) throws DataNotFoundException, MultipleRowException {
        String queryString = query.toString();
        return this.getRecord(queryString, creator, message, key, -1, checkUnique);
    }

    public <T> T getRecord(QueryTemplate query, RecordCreator<T> creator, String message, String key) throws DataNotFoundException, MultipleRowException {
        return this.getRecord(query, creator, message, key, true);
    }

    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (SQLException e2) {
            throw new DataAccessException(e2);
        }
    }

    protected int getFieldMax(String tableName, String field) {
        return this.getMax("SELECT MAX(" + field + ") FROM " + tableName);
    }

    protected int getFieldMaxCondition(String tableName, String field, QueryTemplate condition) {
        return this.getFieldMaxCondition(tableName, field, condition.toString());
    }

    protected int getFieldMaxCondition(String tableName, String field, String condition) {
        return this.getMax("SELECT MAX(" + field + ") FROM " + tableName + " WHERE " + condition);
    }

    private int getMax(String query) {
        int max;
        try {
            max = this.queryForInt(query);
        }
        catch (DataNotFoundException e2) {
            max = 0;
        }
        return max;
    }

    public void startTransaction() {
        this.setAutoCommit(false);
    }

    public void commit() {
        try {
            try {
                this.connection.commit();
            }
            catch (SQLException e2) {
                throw new DataAccessException(e2);
            }
        }
        finally {
            this.setAutoCommit(true);
        }
    }

    public static String loadTemplate(ClassLoader classLoader, String fileName) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream stream = classLoader.getResourceAsStream(fileName);){
            if (stream == null) {
                throw new FileNotFoundException(fileName);
            }
            return ConnectionManager.loadTemplate(stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String loadTemplate(InputStream stream) throws IOException {
        StringBuilder builder = new StringBuilder();
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            InputStreamReader reader = new InputStreamReader(stream);
            try {
                try (BufferedReader br = new BufferedReader(reader);){
                    String line;
                    while ((line = br.readLine()) != null) {
                        builder.append(String.valueOf(line) + " ");
                    }
                }
                if (reader == null) return builder.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (reader == null) throw throwable;
                ((Reader)reader).close();
                throw throwable;
            }
            ((Reader)reader).close();
            return builder.toString();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void logSQLExceptionData(SQLException exc, ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        StringBuilder build = new StringBuilder();
        String excString = exc.toString();
        build.append(excString);
        build.append(" : |");
        int column = 1;
        while (column <= columnCount) {
            build.append(rs.getString(column)).append("|");
            ++column;
        }
        String rsString = build.toString();
        this.logger.log(Level.SEVERE, rsString);
    }

    public boolean multiUpdate(MultiUpdateHandler handler) throws BatchUpdateException, SQLException, UnrecoverableException {
        boolean ok = false;
        try {
            this.startTransaction();
            handler.executeMultiUpdate();
            this.commit();
            ok = true;
        }
        finally {
            if (!ok) {
                this.rollback();
            }
        }
        return ok;
    }

    public boolean executeMultiUpdate(MultiUpdateHandler updateHandler, MultiExceptionHandler exceptionHandler) {
        boolean ok;
        try {
            ok = this.multiUpdate(updateHandler);
        }
        catch (BatchUpdateException exc) {
            SQLException e2 = exc.getNextException();
            do {
                exceptionHandler.handle(e2);
            } while ((e2 = e2.getNextException()) != null);
            exceptionHandler.handle(exc);
            ok = false;
        }
        catch (SQLException | UnrecoverableException exc) {
            exceptionHandler.handle(exc);
            ok = false;
        }
        return ok;
    }
}

