/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.db;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

public class QueryTemplate {
    private String query;

    public static String toSqlString(String value) {
        String text = value == null ? "null" : "'" + value.replace("'", "''") + "'";
        return text;
    }

    public static String toSqlString(int value) {
        return QueryTemplate.toSqlString(String.valueOf(value));
    }

    public static String toSqlString(double value) {
        return QueryTemplate.toSqlString(String.valueOf(value));
    }

    public static String toSqlString(boolean value) {
        return QueryTemplate.toSqlString(value ? "t" : "f");
    }

    public static String toSqlString(Date date, DateFormat format) {
        String sqlString;
        if (date == null) {
            sqlString = "null";
        } else {
            String value = format.format(date);
            sqlString = QueryTemplate.toSqlString(value);
        }
        return sqlString;
    }

    public QueryTemplate(String template) {
        this.query = template;
    }

    public void replaceNull(String key) {
        this.query = this.query.replace(key, "null");
    }

    public void replaceRaw(String key, String value) {
        this.query = this.query.replace(key, value);
    }

    public void replace(String key, String value) {
        this.query = this.query.replace(key, QueryTemplate.toSqlString(value));
    }

    public void replace(String key, int value) {
        this.query = this.query.replace(key, QueryTemplate.toSqlString(value));
    }

    public void replace(String key, Integer value) {
        if (value == null) {
            this.query = this.query.replace(key, "null");
        } else {
            int intValue = value;
            this.query = this.query.replace(key, QueryTemplate.toSqlString(intValue));
        }
    }

    public void replace(String key, double value) {
        this.query = this.query.replace(key, QueryTemplate.toSqlString(value));
    }

    public void replace(String key, boolean value) {
        this.query = this.query.replace(key, QueryTemplate.toSqlString(value));
    }

    @Deprecated
    public void replace(String key, Date date) {
        this.replace(key, date, new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS"));
    }

    public void replace(String key, Date value, DateFormat format) {
        String sqlString = QueryTemplate.toSqlString(value, format);
        this.query = this.query.replace(key, sqlString);
    }

    public String toString() {
        return this.query;
    }

    public void replace(String key, Iterable<?> objects) {
        if (objects != null) {
            StringBuilder builder = new StringBuilder();
            Iterator<?> iterator = objects.iterator();
            if (iterator.hasNext()) {
                while (true) {
                    Object object = iterator.next();
                    String string = object.toString();
                    String sqlString = QueryTemplate.toSqlString(string);
                    builder.append(sqlString);
                    if (!iterator.hasNext()) break;
                    builder.append(",");
                }
            }
            String value = builder.toString();
            this.query = this.query.replace(key, value);
        }
    }

    public void replace(String key, Number value) {
        if (value == null) {
            this.query = this.query.replace(key, "null");
        } else {
            this.replace(key, value.doubleValue());
        }
    }
}

