/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.springtools.web.controllers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.homelinux.elabor.springtools.domain.attachment.DefaultAttachment;

public class DownloadHelper {
    public static byte[] getContent(File file) throws IOException {
        int length = (int)file.length();
        byte[] array = new byte[length];
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream stream = new BufferedInputStream(fileInputStream);
        int read = ((InputStream)stream).read(array, 0, length);
        ((InputStream)stream).close();
        if (read != length) {
            throw new IOException("Read error occurred: read " + read + "bytes but " + length + " was expected");
        }
        return array;
    }

    public static void setUpFileResponse(File file, HttpServletResponse response) throws IOException {
        String fileName = file.getName();
        DownloadHelper.setUpFileResponseWithName(file, fileName, response);
    }

    public static void setUpFileResponseWithName(File file, String fileName, HttpServletResponse response) throws IOException {
        DefaultAttachment attachment = new DefaultAttachment();
        attachment.setFileName(fileName);
        attachment.setContent(file);
        String contentType = attachment.getContentType();
        byte[] content = attachment.getContent();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        DownloadHelper.setUpResponse(content, contentType, response);
    }

    public static void setUpFileResponse(File file, String contentType, HttpServletResponse response) throws IOException {
        DefaultAttachment attachment = new DefaultAttachment();
        String fileName = file.getName();
        attachment.setFileName(fileName);
        attachment.setContentType(contentType);
        attachment.setContent(file);
        byte[] content = attachment.getContent();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        DownloadHelper.setUpResponse(content, contentType, response);
    }

    public static void setUpResponse(byte[] content, String contentType, HttpServletResponse response) throws IOException {
        int size = content.length;
        response.setBufferSize(size);
        response.setContentType(contentType);
        response.setContentLength(size);
        ServletOutputStream ouputStream = response.getOutputStream();
        ouputStream.write(content, 0, size);
        ouputStream.flush();
        ouputStream.close();
    }

    public static void setUpPlainTextResponse(String content, HttpServletResponse response) throws IOException {
        response.setContentType("text/plain");
        ServletOutputStream ouputStream = response.getOutputStream();
        ouputStream.print(content);
        ouputStream.flush();
        ouputStream.close();
    }
}

