/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;

public class Cache<K, D extends Serializable> {
    private static final String NOT_A_DIRECTORY = "non \u00e8 una directory";
    private static final String SAVE_IMPOSSIBLE = "Impossibile salvare il file";
    private static final String LOAD_IMPOSSIBLE = "Impossibile caricare il file";
    private Map<K, D> memoryCache;
    private TreeMap<Long, K> dates;
    private int maxSize;
    private File directory;

    public Cache(File directory, int maxSize) {
        this.directory = directory;
        if (!this.directory.exists()) {
            this.directory.mkdirs();
        }
        if (!this.directory.isDirectory()) {
            JOptionPane.showMessageDialog(null, String.valueOf(this.directory.getName()) + " " + NOT_A_DIRECTORY);
        }
        this.maxSize = maxSize;
        this.memoryCache = new HashMap<K, D>();
        this.dates = new TreeMap();
    }

    public synchronized void put(K key, D data) {
        this.memoryPut(key, data);
        this.save(key, data);
    }

    public D get(K key) {
        Serializable data = (Serializable)this.memoryCache.get(key);
        if (data == null) {
            data = this.load(key);
        }
        return (D)data;
    }

    public void memoryPut(K key, D data) {
        while (this.memoryCache.size() > this.maxSize) {
            Long removeDate = this.dates.firstKey();
            K removeKey = this.dates.get(removeDate);
            this.memoryCache.remove(removeKey);
            this.dates.remove(removeDate);
        }
        this.memoryCache.put(key, data);
        long time = new Date().getTime();
        Long date = time;
        while (this.dates.get(date) != null) {
            time = date + 1L;
            date = time;
        }
        this.dates.put(date, (Long)key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void save(K key, D data) {
        if (this.directory == null) return;
        try {
            File saveFile = this.getFile(key);
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                FileOutputStream fos = new FileOutputStream(saveFile);
                try {
                    try (ObjectOutputStream oos = new ObjectOutputStream(fos);){
                        oos.writeObject(data);
                    }
                    if (fos == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException exception) {
            this.showMessage(key, exception, SAVE_IMPOSSIBLE);
        }
    }

    private void showMessage(K key, Exception exception, String message) {
        JOptionPane.showMessageDialog(null, String.valueOf(message) + " " + key + "(" + exception.getMessage() + ")");
    }

    private File getFile(K key) throws UnsupportedEncodingException {
        return new File(this.directory, URLEncoder.encode(key.toString(), "utf-8"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private D load(K key) {
        Serializable data = null;
        try {
            File saveFile = this.getFile(key);
            if (!saveFile.exists()) return (D)data;
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                FileInputStream fis = new FileInputStream(saveFile);
                try {
                    try (ObjectInputStream ois = new ObjectInputStream(fis);){
                        data = (Serializable)ois.readObject();
                    }
                    if (fis == null) return (D)data;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
                return (D)data;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            this.showMessage(key, exception, LOAD_IMPOSSIBLE);
        }
        return (D)data;
    }
}

