/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.tools;

import java.util.ArrayList;
import java.util.List;
import org.homelinux.elabor.tools.UnicodeChar;

public class UnicodeData {
    private UnicodeData() {
    }

    public static String getHexCode(int codePoint) {
        String unicode = Integer.toHexString(codePoint);
        while (unicode.length() < 4) {
            unicode = String.valueOf('0') + unicode;
        }
        return "U+" + unicode;
    }

    public static List<UnicodeChar> getDescriptions(String string) {
        ArrayList<UnicodeChar> descriptions = new ArrayList<UnicodeChar>();
        int length = string.length();
        int index = 0;
        while (index < length) {
            String uChar;
            String description = uChar = string.substring(index, index + 1);
            int code = string.codePointAt(index);
            description = String.valueOf(description) + " - " + UnicodeData.getHexCode(code);
            Character.UnicodeBlock block = Character.UnicodeBlock.of(code);
            String language = block == null ? "unknown" : block.toString();
            description = String.valueOf(description) + " (" + language + ")";
            UnicodeChar unicodeChar = new UnicodeChar(uChar, description);
            descriptions.add(unicodeChar);
            ++index;
        }
        return descriptions;
    }
}

