/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.tools.batcher;

import java.util.ArrayList;
import java.util.List;
import org.homelinux.elabor.tools.batcher.Batcher;

public class MultipageBatcher<E>
implements Batcher<E> {
    private List<E> elements;
    private int batchSize;
    private int index;

    public MultipageBatcher(int batchSize) {
        this.batchSize = batchSize;
    }

    public MultipageBatcher(List<E> elements, int batchSize) {
        this(batchSize);
        this.setElements(elements);
    }

    public void setElements(List<E> elements) {
        this.elements = elements;
        this.index = 0;
    }

    private List<E> getBatch() {
        int start = this.index * this.batchSize;
        int end = Math.min((this.index + 1) * this.batchSize, this.elements.size());
        return this.elements.subList(start, end);
    }

    public int getIndex() {
        return this.index;
    }

    public List<E> previous() {
        List batch;
        if (this.hasPrevious()) {
            --this.index;
            batch = this.getBatch();
        } else {
            batch = new ArrayList();
        }
        return batch;
    }

    public List<E> next() {
        List<E> batch;
        if (this.hasNext()) {
            batch = this.getBatch();
            ++this.index;
        } else {
            batch = new ArrayList();
        }
        return batch;
    }

    @Override
    public List<E> get(int cursor) {
        this.index = cursor - 1;
        return this.next();
    }

    public List<E> getAll() {
        return this.elements;
    }

    @Override
    public int size() {
        double ratio = (double)this.elements.size() / (double)this.batchSize;
        return (int)Math.ceil(ratio);
    }

    public boolean hasNext() {
        return this.index < this.size();
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }
}

