/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.ui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class ListCellStrokeRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Dimension PREFERRED_SIZE = new Dimension(80, 20);
    private transient Stroke stroke;

    @Override
    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        Graphics2D g22 = (Graphics2D)g2;
        g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        double xx = insets.left;
        double yy = insets.top;
        double ww = size.getWidth() - (double)insets.left - (double)insets.right;
        double hh = size.getHeight() - (double)insets.top - (double)insets.bottom;
        Point2D.Double one = new Point2D.Double(xx + 6.0, yy + hh / 2.0);
        Point2D.Double two = new Point2D.Double(xx + ww - 6.0, yy + hh / 2.0);
        Line2D.Double line = new Line2D.Double(one, two);
        g22.setStroke(this.stroke);
        g22.draw(line);
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        this.setPreferredSize(PREFERRED_SIZE);
        this.setText("");
        this.stroke = (Stroke)value;
        return this;
    }
}

