/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.LogTick;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.NumberTickUnitSource;
import org.jfree.chart.axis.TickType;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.util.AttrStringUtils;
import org.jfree.chart.util.LogFormat;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtilities;

public class LogAxis
extends ValueAxis {
    private double base = 10.0;
    private double baseLog = Math.log(10.0);
    private String baseSymbol = null;
    private Format baseFormatter = new DecimalFormat("0");
    private double smallestValue = 1.0E-100;
    private NumberTickUnit tickUnit;
    private NumberFormat numberFormatOverride;

    public LogAxis() {
        this(null);
    }

    public LogAxis(String label) {
        super(label, new NumberTickUnitSource());
        this.setDefaultAutoRange(new Range(0.01, 1.0));
        this.tickUnit = new NumberTickUnit(1.0, new DecimalFormat("0.#"), 10);
    }

    public double getBase() {
        return this.base;
    }

    public void setBase(double base) {
        if (base <= 1.0) {
            throw new IllegalArgumentException("Requires 'base' > 1.0.");
        }
        this.base = base;
        this.baseLog = Math.log(base);
        this.fireChangeEvent();
    }

    public String getBaseSymbol() {
        return this.baseSymbol;
    }

    public void setBaseSymbol(String symbol) {
        this.baseSymbol = symbol;
        this.fireChangeEvent();
    }

    public Format getBaseFormatter() {
        return this.baseFormatter;
    }

    public void setBaseFormatter(Format formatter) {
        ParamChecks.nullNotPermitted(formatter, "formatter");
        this.baseFormatter = formatter;
        this.fireChangeEvent();
    }

    public double getSmallestValue() {
        return this.smallestValue;
    }

    public void setSmallestValue(double value) {
        if (value <= 0.0) {
            throw new IllegalArgumentException("Requires 'value' > 0.0.");
        }
        this.smallestValue = value;
        this.fireChangeEvent();
    }

    public NumberTickUnit getTickUnit() {
        return this.tickUnit;
    }

    public void setTickUnit(NumberTickUnit unit) {
        this.setTickUnit(unit, true, true);
    }

    public void setTickUnit(NumberTickUnit unit, boolean notify, boolean turnOffAutoSelect) {
        ParamChecks.nullNotPermitted(unit, "unit");
        this.tickUnit = unit;
        if (turnOffAutoSelect) {
            this.setAutoTickUnitSelection(false, false);
        }
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public NumberFormat getNumberFormatOverride() {
        return this.numberFormatOverride;
    }

    public void setNumberFormatOverride(NumberFormat formatter) {
        this.numberFormatOverride = formatter;
        this.fireChangeEvent();
    }

    public double calculateLog(double value) {
        return Math.log(value) / this.baseLog;
    }

    public double calculateValue(double log) {
        return Math.pow(this.base, log);
    }

    private double calculateValueNoINF(double log) {
        double result = this.calculateValue(log);
        if (Double.isInfinite(result)) {
            result = Double.MAX_VALUE;
        }
        if (result <= 0.0) {
            result = Double.MIN_VALUE;
        }
        return result;
    }

    @Override
    public double java2DToValue(double java2DValue, Rectangle2D area, RectangleEdge edge) {
        Range range = this.getRange();
        double axisMin = this.calculateLog(Math.max(this.smallestValue, range.getLowerBound()));
        double axisMax = this.calculateLog(range.getUpperBound());
        double min = 0.0;
        double max = 0.0;
        if (RectangleEdge.isTopOrBottom(edge)) {
            min = area.getX();
            max = area.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(edge)) {
            min = area.getMaxY();
            max = area.getY();
        }
        double log = this.isInverted() ? axisMax - (java2DValue - min) / (max - min) * (axisMax - axisMin) : axisMin + (java2DValue - min) / (max - min) * (axisMax - axisMin);
        return this.calculateValue(log);
    }

    @Override
    public double valueToJava2D(double value, Rectangle2D area, RectangleEdge edge) {
        Range range = this.getRange();
        double axisMin = this.calculateLog(range.getLowerBound());
        double axisMax = this.calculateLog(range.getUpperBound());
        value = this.calculateLog(value);
        double min = 0.0;
        double max = 0.0;
        if (RectangleEdge.isTopOrBottom(edge)) {
            min = area.getX();
            max = area.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(edge)) {
            max = area.getMinY();
            min = area.getMaxY();
        }
        if (this.isInverted()) {
            return max - (value - axisMin) / (axisMax - axisMin) * (max - min);
        }
        return min + (value - axisMin) / (axisMax - axisMin) * (max - min);
    }

    @Override
    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    @Override
    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot vap = (ValueAxisPlot)((Object)plot);
            Range r2 = vap.getDataRange(this);
            if (r2 == null) {
                r2 = this.getDefaultAutoRange();
            }
            double upper = r2.getUpperBound();
            double lower = Math.max(r2.getLowerBound(), this.smallestValue);
            double range = upper - lower;
            double fixedAutoRange = this.getFixedAutoRange();
            if (fixedAutoRange > 0.0) {
                lower = Math.max(upper - fixedAutoRange, this.smallestValue);
            } else {
                double minRange = this.getAutoRangeMinimumSize();
                if (range < minRange) {
                    double expand = (minRange - range) / 2.0;
                    upper += expand;
                    lower -= expand;
                }
                double logUpper = this.calculateLog(upper);
                double logLower = this.calculateLog(lower);
                double logRange = logUpper - logLower;
                upper = this.calculateValueNoINF(logUpper += this.getUpperMargin() * logRange);
                lower = this.calculateValueNoINF(logLower -= this.getLowerMargin() * logRange);
            }
            this.setRange(new Range(lower, upper), false, false);
        }
    }

    @Override
    public AxisState draw(Graphics2D g2, double cursor, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge, PlotRenderingInfo plotState) {
        if (!this.isVisible()) {
            AxisState state = new AxisState(cursor);
            List ticks = this.refreshTicks(g2, state, dataArea, edge);
            state.setTicks(ticks);
            return state;
        }
        AxisState state = this.drawTickMarksAndLabels(g2, cursor, plotArea, dataArea, edge);
        state = this.getAttributedLabel() != null ? this.drawAttributedLabel(this.getAttributedLabel(), g2, plotArea, dataArea, edge, state) : this.drawLabel(this.getLabel(), g2, plotArea, dataArea, edge, state);
        this.createAndAddEntity(cursor, state, dataArea, edge, plotState);
        return state;
    }

    @Override
    public List refreshTicks(Graphics2D g2, AxisState state, Rectangle2D dataArea, RectangleEdge edge) {
        List result = new ArrayList();
        if (RectangleEdge.isTopOrBottom(edge)) {
            result = this.refreshTicksHorizontal(g2, dataArea, edge);
        } else if (RectangleEdge.isLeftOrRight(edge)) {
            result = this.refreshTicksVertical(g2, dataArea, edge);
        }
        return result;
    }

    protected List refreshTicksHorizontal(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
        boolean hasTicks;
        Range range = this.getRange();
        ArrayList<LogTick> ticks = new ArrayList<LogTick>();
        Font tickLabelFont = this.getTickLabelFont();
        g2.setFont(tickLabelFont);
        TextAnchor textAnchor = edge == RectangleEdge.TOP ? TextAnchor.BOTTOM_CENTER : TextAnchor.TOP_CENTER;
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(g2, dataArea, edge);
        }
        int minorTickCount = this.tickUnit.getMinorTickCount();
        double unit = this.getTickUnit().getSize();
        double index = Math.ceil(this.calculateLog(this.getRange().getLowerBound()) / unit);
        double start = index * unit;
        double end = this.calculateLog(this.getUpperBound());
        boolean bl = hasTicks = this.tickUnit.getSize() > 0.0 && !Double.isInfinite(start);
        for (double current = start; hasTicks && current <= end; current += this.tickUnit.getSize()) {
            double v = this.calculateValueNoINF(current);
            if (range.contains(v)) {
                ticks.add(new LogTick(TickType.MAJOR, v, this.createTickLabel(v), textAnchor));
            }
            double next = Math.pow(this.base, current + this.tickUnit.getSize());
            for (int i2 = 1; i2 < minorTickCount; ++i2) {
                double minorV = v + (double)i2 * ((next - v) / (double)minorTickCount);
                if (!range.contains(minorV)) continue;
                ticks.add(new LogTick(TickType.MINOR, minorV, null, textAnchor));
            }
        }
        return ticks;
    }

    protected List refreshTicksVertical(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
        boolean hasTicks;
        Range range = this.getRange();
        ArrayList<LogTick> ticks = new ArrayList<LogTick>();
        Font tickLabelFont = this.getTickLabelFont();
        g2.setFont(tickLabelFont);
        TextAnchor textAnchor = edge == RectangleEdge.RIGHT ? TextAnchor.CENTER_LEFT : TextAnchor.CENTER_RIGHT;
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(g2, dataArea, edge);
        }
        int minorTickCount = this.tickUnit.getMinorTickCount();
        double unit = this.getTickUnit().getSize();
        double index = Math.ceil(this.calculateLog(this.getRange().getLowerBound()) / unit);
        double start = index * unit;
        double end = this.calculateLog(this.getUpperBound());
        boolean bl = hasTicks = this.tickUnit.getSize() > 0.0 && !Double.isInfinite(start);
        for (double current = start; hasTicks && current <= end; current += this.tickUnit.getSize()) {
            double v = this.calculateValueNoINF(current);
            if (range.contains(v)) {
                ticks.add(new LogTick(TickType.MAJOR, v, this.createTickLabel(v), textAnchor));
            }
            double next = Math.pow(this.base, current + this.tickUnit.getSize());
            for (int i2 = 1; i2 < minorTickCount; ++i2) {
                double minorV = v + (double)i2 * ((next - v) / (double)minorTickCount);
                if (!range.contains(minorV)) continue;
                ticks.add(new LogTick(TickType.MINOR, minorV, null, textAnchor));
            }
        }
        return ticks;
    }

    protected void selectAutoTickUnit(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
        if (RectangleEdge.isTopOrBottom(edge)) {
            this.selectHorizontalAutoTickUnit(g2, dataArea, edge);
        } else if (RectangleEdge.isLeftOrRight(edge)) {
            this.selectVerticalAutoTickUnit(g2, dataArea, edge);
        }
    }

    protected void selectHorizontalAutoTickUnit(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
        TickUnit candidate;
        Range range = this.getRange();
        double logAxisMin = this.calculateLog(Math.max(this.smallestValue, range.getLowerBound()));
        double logAxisMax = this.calculateLog(range.getUpperBound());
        double size = (logAxisMax - logAxisMin) / 50.0;
        TickUnitSource tickUnits = this.getStandardTickUnits();
        TickUnit prevCandidate = candidate = tickUnits.getCeilingTickUnit(size);
        boolean found = false;
        while (!found) {
            double candidateWidth;
            this.tickUnit = (NumberTickUnit)candidate;
            double tickLabelWidth = this.estimateMaximumTickLabelWidth(g2, candidate);
            if (tickLabelWidth < (candidateWidth = this.exponentLengthToJava2D(candidate.getSize(), dataArea, edge))) {
                found = true;
                continue;
            }
            if (Double.isNaN(candidateWidth)) {
                candidate = prevCandidate;
                found = true;
                continue;
            }
            prevCandidate = candidate;
            if (!(candidate = tickUnits.getLargerTickUnit(prevCandidate)).equals(prevCandidate)) continue;
            found = true;
        }
        this.setTickUnit((NumberTickUnit)candidate, false, false);
    }

    public double exponentLengthToJava2D(double length, Rectangle2D area, RectangleEdge edge) {
        double one = this.valueToJava2D(this.calculateValueNoINF(1.0), area, edge);
        double l2 = this.valueToJava2D(this.calculateValueNoINF(length + 1.0), area, edge);
        return Math.abs(l2 - one);
    }

    protected void selectVerticalAutoTickUnit(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
        TickUnit candidate;
        Range range = this.getRange();
        double logAxisMin = this.calculateLog(Math.max(this.smallestValue, range.getLowerBound()));
        double logAxisMax = this.calculateLog(range.getUpperBound());
        double size = (logAxisMax - logAxisMin) / 50.0;
        TickUnitSource tickUnits = this.getStandardTickUnits();
        TickUnit prevCandidate = candidate = tickUnits.getCeilingTickUnit(size);
        boolean found = false;
        while (!found) {
            double candidateHeight;
            this.tickUnit = (NumberTickUnit)candidate;
            double tickLabelHeight = this.estimateMaximumTickLabelHeight(g2);
            if (tickLabelHeight < (candidateHeight = this.exponentLengthToJava2D(candidate.getSize(), dataArea, edge))) {
                found = true;
                continue;
            }
            if (Double.isNaN(candidateHeight)) {
                candidate = prevCandidate;
                found = true;
                continue;
            }
            prevCandidate = candidate;
            if (!(candidate = tickUnits.getLargerTickUnit(prevCandidate)).equals(prevCandidate)) continue;
            found = true;
        }
        this.setTickUnit((NumberTickUnit)candidate, false, false);
    }

    protected AttributedString createTickLabel(double value) {
        if (this.numberFormatOverride != null) {
            return new AttributedString(this.numberFormatOverride.format(value));
        }
        String baseStr = this.baseSymbol;
        if (baseStr == null) {
            baseStr = this.baseFormatter.format(this.base);
        }
        double logy = this.calculateLog(value);
        String exponentStr = this.getTickUnit().valueToString(logy);
        AttributedString as = new AttributedString(baseStr + exponentStr);
        as.addAttributes(this.getTickLabelFont().getAttributes(), 0, (baseStr + exponentStr).length());
        as.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, baseStr.length(), baseStr.length() + exponentStr.length());
        return as;
    }

    protected double estimateMaximumTickLabelHeight(Graphics2D g2) {
        RectangleInsets tickLabelInsets = this.getTickLabelInsets();
        double result = tickLabelInsets.getTop() + tickLabelInsets.getBottom();
        Font tickLabelFont = this.getTickLabelFont();
        FontRenderContext frc = g2.getFontRenderContext();
        return result += (double)tickLabelFont.getLineMetrics("123", frc).getHeight();
    }

    protected double estimateMaximumTickLabelWidth(Graphics2D g2, TickUnit unit) {
        RectangleInsets tickLabelInsets = this.getTickLabelInsets();
        double result = tickLabelInsets.getLeft() + tickLabelInsets.getRight();
        if (this.isVerticalTickLabels()) {
            FontRenderContext frc = g2.getFontRenderContext();
            LineMetrics lm = this.getTickLabelFont().getLineMetrics("0", frc);
            result += (double)lm.getHeight();
        } else {
            Range range = this.getRange();
            double lower = range.getLowerBound();
            double upper = range.getUpperBound();
            AttributedString lowerStr = this.createTickLabel(lower);
            AttributedString upperStr = this.createTickLabel(upper);
            double w1 = AttrStringUtils.getTextBounds(lowerStr, g2).getWidth();
            double w2 = AttrStringUtils.getTextBounds(upperStr, g2).getWidth();
            result += Math.max(w1, w2);
        }
        return result;
    }

    @Override
    public void zoomRange(double lowerPercent, double upperPercent) {
        Range adjusted;
        Range range = this.getRange();
        double start = range.getLowerBound();
        double end = range.getUpperBound();
        double log1 = this.calculateLog(start);
        double log2 = this.calculateLog(end);
        double length = log2 - log1;
        if (this.isInverted()) {
            double logA = log1 + length * (1.0 - upperPercent);
            double logB = log1 + length * (1.0 - lowerPercent);
            adjusted = new Range(this.calculateValueNoINF(logA), this.calculateValueNoINF(logB));
        } else {
            double logA = log1 + length * lowerPercent;
            double logB = log1 + length * upperPercent;
            adjusted = new Range(this.calculateValueNoINF(logA), this.calculateValueNoINF(logB));
        }
        this.setRange(adjusted);
    }

    @Override
    public void pan(double percent) {
        Range range = this.getRange();
        double lower = range.getLowerBound();
        double upper = range.getUpperBound();
        double log1 = this.calculateLog(lower);
        double log2 = this.calculateLog(upper);
        double length = log2 - log1;
        double adj = length * percent;
        this.setRange(this.calculateValueNoINF(log1 += adj), this.calculateValueNoINF(log2 += adj));
    }

    @Override
    public void resizeRange(double percent) {
        Range range = this.getRange();
        double logMin = this.calculateLog(range.getLowerBound());
        double logMax = this.calculateLog(range.getUpperBound());
        double centralValue = this.calculateValueNoINF((logMin + logMax) / 2.0);
        this.resizeRange(percent, centralValue);
    }

    @Override
    public void resizeRange(double percent, double anchorValue) {
        this.resizeRange2(percent, anchorValue);
    }

    @Override
    public void resizeRange2(double percent, double anchorValue) {
        if (percent > 0.0) {
            double logAnchorValue = this.calculateLog(anchorValue);
            Range range = this.getRange();
            double logAxisMin = this.calculateLog(range.getLowerBound());
            double logAxisMax = this.calculateLog(range.getUpperBound());
            double left = percent * (logAnchorValue - logAxisMin);
            double right = percent * (logAxisMax - logAnchorValue);
            double upperBound = this.calculateValueNoINF(logAnchorValue + right);
            Range adjusted = new Range(this.calculateValueNoINF(logAnchorValue - left), upperBound);
            this.setRange(adjusted);
        } else {
            this.setAutoRange(true);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LogAxis)) {
            return false;
        }
        LogAxis that = (LogAxis)obj;
        if (this.base != that.base) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseSymbol, that.baseSymbol)) {
            return false;
        }
        if (!this.baseFormatter.equals(that.baseFormatter)) {
            return false;
        }
        if (this.smallestValue != that.smallestValue) {
            return false;
        }
        if (!ObjectUtilities.equal(this.numberFormatOverride, that.numberFormatOverride)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int result = 193;
        long temp = Double.doubleToLongBits(this.base);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.smallestValue);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        if (this.numberFormatOverride != null) {
            result = 37 * result + this.numberFormatOverride.hashCode();
        }
        result = 37 * result + this.tickUnit.hashCode();
        return result;
    }

    public static TickUnitSource createLogTickUnits(Locale locale) {
        TickUnits units = new TickUnits();
        LogFormat numberFormat = new LogFormat();
        units.add(new NumberTickUnit(0.05, numberFormat, 2));
        units.add(new NumberTickUnit(0.1, numberFormat, 10));
        units.add(new NumberTickUnit(0.2, numberFormat, 2));
        units.add(new NumberTickUnit(0.5, numberFormat, 5));
        units.add(new NumberTickUnit(1.0, numberFormat, 10));
        units.add(new NumberTickUnit(2.0, numberFormat, 10));
        units.add(new NumberTickUnit(3.0, numberFormat, 15));
        units.add(new NumberTickUnit(4.0, numberFormat, 20));
        units.add(new NumberTickUnit(5.0, numberFormat, 25));
        units.add(new NumberTickUnit(6.0, numberFormat));
        units.add(new NumberTickUnit(7.0, numberFormat));
        units.add(new NumberTickUnit(8.0, numberFormat));
        units.add(new NumberTickUnit(9.0, numberFormat));
        units.add(new NumberTickUnit(10.0, numberFormat));
        return units;
    }
}

