/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.lang.reflect.Constructor;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.Year;
import org.jfree.date.MonthConstants;

public abstract class RegularTimePeriod
implements TimePeriod,
Comparable,
MonthConstants {
    public static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getDefault();
    public static final Calendar WORKING_CALENDAR = Calendar.getInstance(DEFAULT_TIME_ZONE);

    public static RegularTimePeriod createInstance(Class c2, Date millisecond, TimeZone zone) {
        RegularTimePeriod result = null;
        try {
            Constructor constructor = c2.getDeclaredConstructor(Date.class, TimeZone.class);
            result = (RegularTimePeriod)constructor.newInstance(millisecond, zone);
        }
        catch (Exception e2) {
            // empty catch block
        }
        return result;
    }

    public static Class downsize(Class c2) {
        if (c2.equals(Year.class)) {
            return Quarter.class;
        }
        if (c2.equals(Quarter.class)) {
            return Month.class;
        }
        if (c2.equals(Month.class)) {
            return Day.class;
        }
        if (c2.equals(Day.class)) {
            return Hour.class;
        }
        if (c2.equals(Hour.class)) {
            return Minute.class;
        }
        if (c2.equals(Minute.class)) {
            return Second.class;
        }
        if (c2.equals(Second.class)) {
            return Millisecond.class;
        }
        return Millisecond.class;
    }

    public abstract RegularTimePeriod previous();

    public abstract RegularTimePeriod next();

    public abstract long getSerialIndex();

    public abstract void peg(Calendar var1);

    @Override
    public Date getStart() {
        return new Date(this.getFirstMillisecond());
    }

    @Override
    public Date getEnd() {
        return new Date(this.getLastMillisecond());
    }

    public abstract long getFirstMillisecond();

    public long getFirstMillisecond(TimeZone zone) {
        Calendar calendar = Calendar.getInstance(zone);
        return this.getFirstMillisecond(calendar);
    }

    public abstract long getFirstMillisecond(Calendar var1);

    public abstract long getLastMillisecond();

    public long getLastMillisecond(TimeZone zone) {
        Calendar calendar = Calendar.getInstance(zone);
        return this.getLastMillisecond(calendar);
    }

    public abstract long getLastMillisecond(Calendar var1);

    public long getMiddleMillisecond() {
        long m1 = this.getFirstMillisecond();
        long m2 = this.getLastMillisecond();
        return m1 + (m2 - m1) / 2L;
    }

    public long getMiddleMillisecond(TimeZone zone) {
        Calendar calendar = Calendar.getInstance(zone);
        long m1 = this.getFirstMillisecond(calendar);
        long m2 = this.getLastMillisecond(calendar);
        return m1 + (m2 - m1) / 2L;
    }

    public long getMiddleMillisecond(Calendar calendar) {
        long m1 = this.getFirstMillisecond(calendar);
        long m2 = this.getLastMillisecond(calendar);
        return m1 + (m2 - m1) / 2L;
    }

    public long getMillisecond(TimePeriodAnchor anchor, Calendar calendar) {
        if (anchor.equals(TimePeriodAnchor.START)) {
            return this.getFirstMillisecond(calendar);
        }
        if (anchor.equals(TimePeriodAnchor.MIDDLE)) {
            return this.getMiddleMillisecond(calendar);
        }
        if (anchor.equals(TimePeriodAnchor.END)) {
            return this.getLastMillisecond(calendar);
        }
        throw new IllegalStateException("Unrecognised anchor: " + anchor);
    }

    public String toString() {
        return String.valueOf(this.getStart());
    }
}

