/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.AjType;
import org.aspectj.lang.reflect.AjTypeSystem;
import org.aspectj.lang.reflect.PerClauseKind;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.aspectj.annotation.AspectJAdvisorFactory;
import org.springframework.aop.aspectj.annotation.NotAnAtAspectException;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.PrioritizedParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAspectJAdvisorFactory
implements AspectJAdvisorFactory {
    protected static final ParameterNameDiscoverer ASPECTJ_ANNOTATION_PARAMETER_NAME_DISCOVERER = new AspectJAnnotationParameterNameDiscoverer();
    private static final String AJC_MAGIC = "ajc$";
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final ParameterNameDiscoverer parameterNameDiscoverer;

    protected static AspectJAnnotation findAspectJAnnotationOnMethod(Method method) {
        Class[] classesToLookFor;
        Class[] classArray = classesToLookFor = new Class[]{Before.class, Around.class, After.class, AfterReturning.class, AfterThrowing.class, Pointcut.class};
        int n2 = classesToLookFor.length;
        int n3 = 0;
        while (n3 < n2) {
            Class c2 = classArray[n3];
            AspectJAnnotation foundAnnotation = AbstractAspectJAdvisorFactory.findAnnotation(method, c2);
            if (foundAnnotation != null) {
                return foundAnnotation;
            }
            ++n3;
        }
        return null;
    }

    private static <A extends Annotation> AspectJAnnotation<A> findAnnotation(Method method, Class<A> toLookFor) {
        A result = AnnotationUtils.findAnnotation(method, toLookFor);
        if (result != null) {
            return new AspectJAnnotation<A>(result);
        }
        return null;
    }

    protected AbstractAspectJAdvisorFactory() {
        PrioritizedParameterNameDiscoverer prioritizedParameterNameDiscoverer = new PrioritizedParameterNameDiscoverer();
        prioritizedParameterNameDiscoverer.addDiscoverer(ASPECTJ_ANNOTATION_PARAMETER_NAME_DISCOVERER);
        this.parameterNameDiscoverer = prioritizedParameterNameDiscoverer;
    }

    @Override
    public boolean isAspect(Class<?> clazz) {
        return this.hasAspectAnnotation(clazz) && !this.compiledByAjc(clazz);
    }

    private boolean hasAspectAnnotation(Class<?> clazz) {
        return AnnotationUtils.findAnnotation(clazz, Aspect.class) != null;
    }

    private boolean compiledByAjc(Class<?> clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n2 = fieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Field field = fieldArray[n3];
            if (field.getName().startsWith(AJC_MAGIC)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    @Override
    public void validate(Class<?> aspectClass) throws AopConfigException {
        if (aspectClass.getSuperclass().getAnnotation(Aspect.class) != null && !Modifier.isAbstract(aspectClass.getSuperclass().getModifiers())) {
            throw new AopConfigException("[" + aspectClass.getName() + "] cannot extend concrete aspect [" + aspectClass.getSuperclass().getName() + "]");
        }
        AjType<?> ajType = AjTypeSystem.getAjType(aspectClass);
        if (!ajType.isAspect()) {
            throw new NotAnAtAspectException(aspectClass);
        }
        if (ajType.getPerClause().getKind() == PerClauseKind.PERCFLOW) {
            throw new AopConfigException(String.valueOf(aspectClass.getName()) + " uses percflow instantiation model: " + "This is not supported in Spring AOP.");
        }
        if (ajType.getPerClause().getKind() == PerClauseKind.PERCFLOWBELOW) {
            throw new AopConfigException(String.valueOf(aspectClass.getName()) + " uses percflowbelow instantiation model: " + "This is not supported in Spring AOP.");
        }
    }

    protected AspectJExpressionPointcut createPointcutExpression(Method annotatedMethod, Class declarationScope, String[] pointcutParameterNames) {
        Class[] pointcutParameterTypes = new Class[]{};
        if (pointcutParameterNames != null) {
            pointcutParameterTypes = this.extractPointcutParameterTypes(pointcutParameterNames, annotatedMethod);
        }
        AspectJExpressionPointcut ajexp = new AspectJExpressionPointcut(declarationScope, pointcutParameterNames, pointcutParameterTypes);
        ajexp.setLocation(annotatedMethod.toString());
        return ajexp;
    }

    private Class<?>[] extractPointcutParameterTypes(String[] argNames, Method adviceMethod) {
        Class[] ret = new Class[argNames.length];
        Class<?>[] paramTypes = adviceMethod.getParameterTypes();
        if (argNames.length > paramTypes.length) {
            throw new IllegalStateException("Expecting at least " + argNames.length + " arguments in the advice declaration, but only found " + paramTypes.length);
        }
        int typeOffset = paramTypes.length - argNames.length;
        int i2 = 0;
        while (i2 < ret.length) {
            ret[i2] = paramTypes[i2 + typeOffset];
            ++i2;
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AspectJAnnotation<A extends Annotation> {
        private static final String[] EXPRESSION_PROPERTIES = new String[]{"value", "pointcut"};
        private static Map<Class, AspectJAnnotationType> annotationTypes = new HashMap<Class, AspectJAnnotationType>();
        private final A annotation;
        private final AspectJAnnotationType annotationType;
        private final String pointcutExpression;
        private final String argumentNames;

        static {
            annotationTypes.put(Pointcut.class, AspectJAnnotationType.AtPointcut);
            annotationTypes.put(After.class, AspectJAnnotationType.AtAfter);
            annotationTypes.put(AfterReturning.class, AspectJAnnotationType.AtAfterReturning);
            annotationTypes.put(AfterThrowing.class, AspectJAnnotationType.AtAfterThrowing);
            annotationTypes.put(Around.class, AspectJAnnotationType.AtAround);
            annotationTypes.put(Before.class, AspectJAnnotationType.AtBefore);
        }

        public AspectJAnnotation(A annotation) {
            this.annotation = annotation;
            this.annotationType = this.determineAnnotationType(annotation);
            try {
                this.pointcutExpression = this.resolveExpression(annotation);
                this.argumentNames = (String)annotation.getClass().getMethod("argNames", new Class[0]).invoke(annotation, new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(annotation + " cannot be an AspectJ annotation", ex);
            }
        }

        private AspectJAnnotationType determineAnnotationType(A annotation) {
            for (Class type : annotationTypes.keySet()) {
                if (!type.isInstance(annotation)) continue;
                return annotationTypes.get(type);
            }
            throw new IllegalStateException("Unknown annotation type: " + annotation.toString());
        }

        private String resolveExpression(A annotation) throws Exception {
            String expression = null;
            String[] stringArray = EXPRESSION_PROPERTIES;
            int n2 = EXPRESSION_PROPERTIES.length;
            int n3 = 0;
            while (n3 < n2) {
                String candidate;
                Method method;
                String methodName = stringArray[n3];
                try {
                    method = annotation.getClass().getDeclaredMethod(methodName, new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    method = null;
                }
                if (method != null && StringUtils.hasText(candidate = (String)method.invoke(annotation, new Object[0]))) {
                    expression = candidate;
                }
                ++n3;
            }
            return expression;
        }

        public AspectJAnnotationType getAnnotationType() {
            return this.annotationType;
        }

        public A getAnnotation() {
            return this.annotation;
        }

        public String getPointcutExpression() {
            return this.pointcutExpression;
        }

        public String getArgumentNames() {
            return this.argumentNames;
        }

        public String toString() {
            return this.annotation.toString();
        }
    }

    private static class AspectJAnnotationParameterNameDiscoverer
    implements ParameterNameDiscoverer {
        private AspectJAnnotationParameterNameDiscoverer() {
        }

        public String[] getParameterNames(Method method) {
            if (method.getParameterTypes().length == 0) {
                return new String[0];
            }
            AspectJAnnotation annotation = AbstractAspectJAdvisorFactory.findAspectJAnnotationOnMethod(method);
            if (annotation == null) {
                return null;
            }
            StringTokenizer strTok = new StringTokenizer(annotation.getArgumentNames(), ",");
            if (strTok.countTokens() > 0) {
                String[] names = new String[strTok.countTokens()];
                int i2 = 0;
                while (i2 < names.length) {
                    names[i2] = strTok.nextToken();
                    ++i2;
                }
                return names;
            }
            return null;
        }

        public String[] getParameterNames(Constructor ctor) {
            throw new UnsupportedOperationException("Spring AOP cannot handle constructor advice");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum AspectJAnnotationType {
        AtPointcut,
        AtBefore,
        AtAfter,
        AtAfterReturning,
        AtAfterThrowing,
        AtAround;

    }
}

