/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.Advisor;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisorChainFactory;
import org.springframework.aop.framework.InterceptorAndDynamicMethodMatcher;
import org.springframework.aop.framework.adapter.AdvisorAdapterRegistry;
import org.springframework.aop.framework.adapter.GlobalAdvisorAdapterRegistry;
import org.springframework.aop.support.MethodMatchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAdvisorChainFactory
implements AdvisorChainFactory,
Serializable {
    @Override
    public List<Object> getInterceptorsAndDynamicInterceptionAdvice(Advised config, Method method, Class targetClass) {
        ArrayList<Object> interceptorList = new ArrayList<Object>(config.getAdvisors().length);
        boolean hasIntroductions = DefaultAdvisorChainFactory.hasMatchingIntroductions(config, targetClass);
        AdvisorAdapterRegistry registry = GlobalAdvisorAdapterRegistry.getInstance();
        Advisor[] advisorArray = config.getAdvisors();
        int n2 = advisorArray.length;
        int n3 = 0;
        while (n3 < n2) {
            MethodInterceptor[] interceptors;
            Advisor advisor = advisorArray[n3];
            if (advisor instanceof PointcutAdvisor) {
                PointcutAdvisor pointcutAdvisor = (PointcutAdvisor)advisor;
                if (config.isPreFiltered() || pointcutAdvisor.getPointcut().getClassFilter().matches(targetClass)) {
                    interceptors = registry.getInterceptors(advisor);
                    MethodMatcher mm = pointcutAdvisor.getPointcut().getMethodMatcher();
                    if (MethodMatchers.matches(mm, method, targetClass, hasIntroductions)) {
                        if (mm.isRuntime()) {
                            MethodInterceptor[] methodInterceptorArray = interceptors;
                            int n4 = interceptors.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                MethodInterceptor interceptor = methodInterceptorArray[n5];
                                interceptorList.add(new InterceptorAndDynamicMethodMatcher(interceptor, mm));
                                ++n5;
                            }
                        } else {
                            interceptorList.addAll((Collection<Object>)Arrays.asList(interceptors));
                        }
                    }
                }
            } else if (advisor instanceof IntroductionAdvisor) {
                IntroductionAdvisor ia = (IntroductionAdvisor)advisor;
                if (config.isPreFiltered() || ia.getClassFilter().matches(targetClass)) {
                    interceptors = registry.getInterceptors(advisor);
                    interceptorList.addAll((Collection<Object>)Arrays.asList(interceptors));
                }
            } else {
                MethodInterceptor[] interceptors2 = registry.getInterceptors(advisor);
                interceptorList.addAll((Collection<Object>)Arrays.asList(interceptors2));
            }
            ++n3;
        }
        return interceptorList;
    }

    private static boolean hasMatchingIntroductions(Advised config, Class targetClass) {
        int i2 = 0;
        while (i2 < config.getAdvisors().length) {
            IntroductionAdvisor ia;
            Advisor advisor = config.getAdvisors()[i2];
            if (advisor instanceof IntroductionAdvisor && (ia = (IntroductionAdvisor)advisor).getClassFilter().matches(targetClass)) {
                return true;
            }
            ++i2;
        }
        return false;
    }
}

