/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class PropertyBatchUpdateException
extends BeansException {
    private PropertyAccessException[] propertyAccessExceptions;

    public PropertyBatchUpdateException(PropertyAccessException[] propertyAccessExceptions) {
        super((String)null);
        Assert.notEmpty(propertyAccessExceptions, "At least 1 PropertyAccessException required");
        this.propertyAccessExceptions = propertyAccessExceptions;
    }

    public final int getExceptionCount() {
        return this.propertyAccessExceptions.length;
    }

    public final PropertyAccessException[] getPropertyAccessExceptions() {
        return this.propertyAccessExceptions;
    }

    public PropertyAccessException getPropertyAccessException(String propertyName) {
        PropertyAccessException[] propertyAccessExceptionArray = this.propertyAccessExceptions;
        int n2 = this.propertyAccessExceptions.length;
        int n3 = 0;
        while (n3 < n2) {
            PropertyAccessException pae = propertyAccessExceptionArray[n3];
            if (ObjectUtils.nullSafeEquals(propertyName, pae.getPropertyName())) {
                return pae;
            }
            ++n3;
        }
        return null;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder("Failed properties: ");
        int i2 = 0;
        while (i2 < this.propertyAccessExceptions.length) {
            sb.append(this.propertyAccessExceptions[i2].getMessage());
            if (i2 < this.propertyAccessExceptions.length - 1) {
                sb.append("; ");
            }
            ++i2;
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append("; nested PropertyAccessExceptions (");
        sb.append(this.getExceptionCount()).append(") are:");
        int i2 = 0;
        while (i2 < this.propertyAccessExceptions.length) {
            sb.append('\n').append("PropertyAccessException ").append(i2 + 1).append(": ");
            sb.append(this.propertyAccessExceptions[i2]);
            ++i2;
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            ps.println(String.valueOf(this.getClass().getName()) + "; nested PropertyAccessException details (" + this.getExceptionCount() + ") are:");
            int i2 = 0;
            while (i2 < this.propertyAccessExceptions.length) {
                ps.println("PropertyAccessException " + (i2 + 1) + ":");
                this.propertyAccessExceptions[i2].printStackTrace(ps);
                ++i2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            pw.println(String.valueOf(this.getClass().getName()) + "; nested PropertyAccessException details (" + this.getExceptionCount() + ") are:");
            int i2 = 0;
            while (i2 < this.propertyAccessExceptions.length) {
                pw.println("PropertyAccessException " + (i2 + 1) + ":");
                this.propertyAccessExceptions[i2].printStackTrace(pw);
                ++i2;
            }
        }
    }

    public boolean contains(Class exType) {
        if (exType == null) {
            return false;
        }
        if (exType.isInstance(this)) {
            return true;
        }
        PropertyAccessException[] propertyAccessExceptionArray = this.propertyAccessExceptions;
        int n2 = this.propertyAccessExceptions.length;
        int n3 = 0;
        while (n3 < n2) {
            PropertyAccessException pae = propertyAccessExceptionArray[n3];
            if (pae.contains(exType)) {
                return true;
            }
            ++n3;
        }
        return false;
    }
}

