/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type;

import java.lang.reflect.Modifier;
import org.springframework.core.type.ClassMetadata;
import org.springframework.util.Assert;

public class StandardClassMetadata
implements ClassMetadata {
    private final Class introspectedClass;

    public StandardClassMetadata(Class introspectedClass) {
        Assert.notNull(introspectedClass, "Class must not be null");
        this.introspectedClass = introspectedClass;
    }

    public final Class getIntrospectedClass() {
        return this.introspectedClass;
    }

    public String getClassName() {
        return this.introspectedClass.getName();
    }

    public boolean isInterface() {
        return this.introspectedClass.isInterface();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.introspectedClass.getModifiers());
    }

    public boolean isConcrete() {
        return !this.isInterface() && !this.isAbstract();
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.introspectedClass.getModifiers());
    }

    public boolean isIndependent() {
        return !this.hasEnclosingClass() || this.introspectedClass.getDeclaringClass() != null && Modifier.isStatic(this.introspectedClass.getModifiers());
    }

    public boolean hasEnclosingClass() {
        return this.introspectedClass.getEnclosingClass() != null;
    }

    public String getEnclosingClassName() {
        Class<?> enclosingClass = this.introspectedClass.getEnclosingClass();
        return enclosingClass != null ? enclosingClass.getName() : null;
    }

    public boolean hasSuperClass() {
        return this.introspectedClass.getSuperclass() != null;
    }

    public String getSuperClassName() {
        Class superClass = this.introspectedClass.getSuperclass();
        return superClass != null ? superClass.getName() : null;
    }

    public String[] getInterfaceNames() {
        Class<?>[] ifcs = this.introspectedClass.getInterfaces();
        String[] ifcNames = new String[ifcs.length];
        int i2 = 0;
        while (i2 < ifcs.length) {
            ifcNames[i2] = ifcs[i2].getName();
            ++i2;
        }
        return ifcNames;
    }
}

