/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.ReflectionHelper;
import org.springframework.util.ReflectionUtils;

public class FunctionReference
extends SpelNodeImpl {
    private final String name;

    public FunctionReference(String functionName, int pos, SpelNodeImpl ... arguments) {
        super(pos, arguments);
        this.name = functionName;
    }

    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        TypedValue o2 = state.lookupVariable(this.name);
        if (o2 == null) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.FUNCTION_NOT_DEFINED, this.name);
        }
        if (!(o2.getValue() instanceof Method)) {
            throw new SpelEvaluationException(SpelMessage.FUNCTION_REFERENCE_CANNOT_BE_INVOKED, this.name, o2.getClass());
        }
        try {
            return this.executeFunctionJLRMethod(state, (Method)o2.getValue());
        }
        catch (SpelEvaluationException se) {
            se.setPosition(this.getStartPosition());
            throw se;
        }
    }

    private TypedValue executeFunctionJLRMethod(ExpressionState state, Method method) throws EvaluationException {
        Object[] functionArgs = this.getArguments(state);
        if (!method.isVarArgs() && method.getParameterTypes().length != functionArgs.length) {
            throw new SpelEvaluationException(SpelMessage.INCORRECT_NUMBER_OF_ARGUMENTS_TO_FUNCTION, functionArgs.length, method.getParameterTypes().length);
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.FUNCTION_MUST_BE_STATIC, String.valueOf(method.getDeclaringClass().getName()) + "." + method.getName(), this.name);
        }
        if (functionArgs != null) {
            TypeConverter converter = state.getEvaluationContext().getTypeConverter();
            ReflectionHelper.convertAllArguments(converter, functionArgs, method);
        }
        if (method.isVarArgs()) {
            functionArgs = ReflectionHelper.setupArgumentsForVarargsInvocation(method.getParameterTypes(), functionArgs);
        }
        try {
            ReflectionUtils.makeAccessible(method);
            Object result = method.invoke(method.getClass(), functionArgs);
            return new TypedValue(result, new TypeDescriptor(new MethodParameter(method, -1)));
        }
        catch (Exception ex) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.EXCEPTION_DURING_FUNCTION_CALL, this.name, ex.getMessage());
        }
    }

    public String toStringAST() {
        StringBuilder sb = new StringBuilder("#").append(this.name);
        sb.append("(");
        int i2 = 0;
        while (i2 < this.getChildCount()) {
            if (i2 > 0) {
                sb.append(",");
            }
            sb.append(this.getChild(i2).toStringAST());
            ++i2;
        }
        sb.append(")");
        return sb.toString();
    }

    private Object[] getArguments(ExpressionState state) throws EvaluationException {
        Object[] arguments = new Object[this.getChildCount()];
        int i2 = 0;
        while (i2 < arguments.length) {
            arguments[i2] = this.children[i2].getValueInternal(state).getValue();
            ++i2;
        }
        return arguments;
    }
}

