/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.init;

import java.io.IOException;
import java.io.LineNumberReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.jdbc.datasource.init.CannotReadScriptException;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.ScriptStatementFailedException;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDatabasePopulator
implements DatabasePopulator {
    private static String DEFAULT_COMMENT_PREFIX = "--";
    private static final Log logger = LogFactory.getLog(ResourceDatabasePopulator.class);
    private List<Resource> scripts = new ArrayList<Resource>();
    private String sqlScriptEncoding;
    private String commentPrefix = DEFAULT_COMMENT_PREFIX;
    private boolean continueOnError = false;
    private boolean ignoreFailedDrops = false;

    public void addScript(Resource script) {
        this.scripts.add(script);
    }

    public void setScripts(Resource[] scripts) {
        this.scripts = Arrays.asList(scripts);
    }

    public void setSqlScriptEncoding(String sqlScriptEncoding) {
        this.sqlScriptEncoding = sqlScriptEncoding;
    }

    public void setCommentPrefix(String commentPrefix) {
        this.commentPrefix = commentPrefix;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public void setIgnoreFailedDrops(boolean ignoreFailedDrops) {
        this.ignoreFailedDrops = ignoreFailedDrops;
    }

    @Override
    public void populate(Connection connection) throws SQLException {
        for (Resource script : this.scripts) {
            this.executeSqlScript(connection, this.applyEncodingIfNecessary(script), this.continueOnError, this.ignoreFailedDrops);
        }
    }

    private EncodedResource applyEncodingIfNecessary(Resource script) {
        if (script instanceof EncodedResource) {
            return (EncodedResource)((Object)script);
        }
        return new EncodedResource(script, this.sqlScriptEncoding);
    }

    private void executeSqlScript(Connection connection, EncodedResource resource, boolean continueOnError, boolean ignoreFailedDrops) throws SQLException {
        String script;
        if (logger.isInfoEnabled()) {
            logger.info("Executing SQL script from " + resource);
        }
        long startTime = System.currentTimeMillis();
        LinkedList<String> statements = new LinkedList<String>();
        try {
            script = this.readScript(resource);
        }
        catch (IOException ex) {
            throw new CannotReadScriptException(resource, (Throwable)ex);
        }
        char delimiter = ';';
        if (!this.containsSqlScriptDelimiters(script, delimiter)) {
            delimiter = '\n';
        }
        this.splitSqlScript(script, delimiter, statements);
        int lineNumber = 0;
        Statement stmt = connection.createStatement();
        try {
            for (String statement : statements) {
                ++lineNumber;
                try {
                    int rowsAffected = stmt.executeUpdate(statement);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(String.valueOf(rowsAffected) + " rows affected by SQL: " + statement);
                }
                catch (SQLException ex) {
                    boolean dropStatement = StringUtils.startsWithIgnoreCase(statement.trim(), "drop");
                    if (continueOnError || dropStatement && ignoreFailedDrops) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Failed to execute SQL script statement at line " + lineNumber + " of resource " + resource + ": " + statement, ex);
                        continue;
                    }
                    throw new ScriptStatementFailedException(statement, lineNumber, resource, ex);
                }
            }
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable ex) {
                logger.debug("Could not close JDBC Statement", ex);
            }
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        if (logger.isInfoEnabled()) {
            logger.info("Done executing SQL script from " + resource + " in " + elapsedTime + " ms.");
        }
    }

    private String readScript(EncodedResource resource) throws IOException {
        LineNumberReader lnr = new LineNumberReader(resource.getReader());
        String currentStatement = lnr.readLine();
        StringBuilder scriptBuilder = new StringBuilder();
        while (currentStatement != null) {
            if (StringUtils.hasText(currentStatement) && this.commentPrefix != null && !currentStatement.startsWith(this.commentPrefix)) {
                if (scriptBuilder.length() > 0) {
                    scriptBuilder.append('\n');
                }
                scriptBuilder.append(currentStatement);
            }
            currentStatement = lnr.readLine();
        }
        return scriptBuilder.toString();
    }

    private boolean containsSqlScriptDelimiters(String script, char delim) {
        boolean inLiteral = false;
        char[] content = script.toCharArray();
        int i2 = 0;
        while (i2 < script.length()) {
            if (content[i2] == '\'') {
                boolean bl = inLiteral = !inLiteral;
            }
            if (content[i2] == delim && !inLiteral) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void splitSqlScript(String script, char delim, List<String> statements) {
        sb = new StringBuilder();
        inLiteral = false;
        content = script.toCharArray();
        i = 0;
        while (i < script.length()) {
            c = content[i];
            if (c == '\'') {
                v0 = inLiteral = inLiteral == false;
            }
            if (inLiteral) ** GOTO lbl18
            if (c == delim) {
                if (sb.length() > 0) {
                    statements.add(sb.toString());
                    sb = new StringBuilder();
                }
            } else {
                if (c == '\n' || c == '\t') {
                    c = ' ';
                }
lbl18:
                // 4 sources

                sb.append(c);
            }
            ++i;
        }
        if (StringUtils.hasText(sb)) {
            statements.add(sb.toString());
        }
    }
}

