/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.jdbc.support.SQLErrorCodes;
import org.springframework.util.Assert;
import org.springframework.util.PatternMatchUtils;

public class SQLErrorCodesFactory {
    public static final String SQL_ERROR_CODE_OVERRIDE_PATH = "sql-error-codes.xml";
    public static final String SQL_ERROR_CODE_DEFAULT_PATH = "org/springframework/jdbc/support/sql-error-codes.xml";
    private static final Log logger = LogFactory.getLog(SQLErrorCodesFactory.class);
    private static final SQLErrorCodesFactory instance = new SQLErrorCodesFactory();
    private final Map<String, SQLErrorCodes> errorCodesMap;
    private final Map<DataSource, SQLErrorCodes> dataSourceCache = new WeakHashMap<DataSource, SQLErrorCodes>(16);

    public static SQLErrorCodesFactory getInstance() {
        return instance;
    }

    protected SQLErrorCodesFactory() {
        Map<Object, Object> errorCodes;
        try {
            DefaultListableBeanFactory lbf = new DefaultListableBeanFactory();
            lbf.setBeanClassLoader(this.getClass().getClassLoader());
            XmlBeanDefinitionReader bdr = new XmlBeanDefinitionReader(lbf);
            Resource resource = this.loadResource(SQL_ERROR_CODE_DEFAULT_PATH);
            if (resource != null && resource.exists()) {
                bdr.loadBeanDefinitions(resource);
            } else {
                logger.warn("Default sql-error-codes.xml not found (should be included in spring.jar)");
            }
            resource = this.loadResource(SQL_ERROR_CODE_OVERRIDE_PATH);
            if (resource != null && resource.exists()) {
                bdr.loadBeanDefinitions(resource);
                logger.info("Found custom sql-error-codes.xml file at the root of the classpath");
            }
            errorCodes = lbf.getBeansOfType(SQLErrorCodes.class, true, false);
            if (logger.isInfoEnabled()) {
                logger.info("SQLErrorCodes loaded: " + errorCodes.keySet());
            }
        }
        catch (BeansException ex) {
            logger.warn("Error loading SQL error codes from config file", ex);
            errorCodes = Collections.emptyMap();
        }
        this.errorCodesMap = errorCodes;
    }

    protected Resource loadResource(String path) {
        return new ClassPathResource(path, this.getClass().getClassLoader());
    }

    public SQLErrorCodes getErrorCodes(String dbName) {
        Assert.notNull(dbName, "Database product name must not be null");
        SQLErrorCodes sec = this.errorCodesMap.get(dbName);
        if (sec == null) {
            for (SQLErrorCodes candidate : this.errorCodesMap.values()) {
                if (!PatternMatchUtils.simpleMatch(candidate.getDatabaseProductNames(), dbName)) continue;
                sec = candidate;
                break;
            }
        }
        if (sec != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("SQL error codes for '" + dbName + "' found");
            }
            return sec;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SQL error codes for '" + dbName + "' not found");
        }
        return new SQLErrorCodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLErrorCodes getErrorCodes(DataSource dataSource) {
        Assert.notNull(dataSource, "DataSource must not be null");
        if (logger.isDebugEnabled()) {
            logger.debug("Looking up default SQLErrorCodes for DataSource [" + dataSource + "]");
        }
        Map<DataSource, SQLErrorCodes> map = this.dataSourceCache;
        synchronized (map) {
            SQLErrorCodes sec = this.dataSourceCache.get(dataSource);
            if (sec != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("SQLErrorCodes found in cache for DataSource [" + dataSource.getClass().getName() + '@' + Integer.toHexString(dataSource.hashCode()) + "]");
                }
                return sec;
            }
            try {
                String dbName = (String)JdbcUtils.extractDatabaseMetaData(dataSource, "getDatabaseProductName");
                if (dbName != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Database product name cached for DataSource [" + dataSource.getClass().getName() + '@' + Integer.toHexString(dataSource.hashCode()) + "]: name is '" + dbName + "'");
                    }
                    sec = this.getErrorCodes(dbName);
                    this.dataSourceCache.put(dataSource, sec);
                    return sec;
                }
            }
            catch (MetaDataAccessException ex) {
                logger.warn("Error while extracting database product name - falling back to empty error codes", ex);
            }
        }
        return new SQLErrorCodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLErrorCodes registerDatabase(DataSource dataSource, String dbName) {
        Map<DataSource, SQLErrorCodes> map = this.dataSourceCache;
        synchronized (map) {
            SQLErrorCodes sec = this.getErrorCodes(dbName);
            this.dataSourceCache.put(dataSource, sec);
            return sec;
        }
    }
}

