/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.expression.method;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.expression.ExpressionUtils;
import org.springframework.security.access.expression.method.DenyAllPermissionEvaluator;
import org.springframework.security.access.expression.method.MethodSecurityEvaluationContext;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionRoot;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;

public class DefaultMethodSecurityExpressionHandler
implements MethodSecurityExpressionHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private PermissionEvaluator permissionEvaluator = new DenyAllPermissionEvaluator();
    private AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();
    private ExpressionParser expressionParser = new SpelExpressionParser();
    private RoleHierarchy roleHierarchy;

    public EvaluationContext createEvaluationContext(Authentication auth, MethodInvocation mi) {
        MethodSecurityEvaluationContext ctx = new MethodSecurityEvaluationContext(auth, mi, this.parameterNameDiscoverer);
        MethodSecurityExpressionRoot root = new MethodSecurityExpressionRoot(auth);
        root.setTrustResolver(this.trustResolver);
        root.setPermissionEvaluator(this.permissionEvaluator);
        root.setRoleHierarchy(this.roleHierarchy);
        ctx.setRootObject(root);
        return ctx;
    }

    public Object filter(Object filterTarget, Expression filterExpression, EvaluationContext ctx) {
        MethodSecurityExpressionRoot rootObject = (MethodSecurityExpressionRoot)ctx.getRootObject().getValue();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Filtering with expression: " + filterExpression.getExpressionString());
        }
        if (filterTarget instanceof Collection) {
            Collection collection = (Collection)filterTarget;
            ArrayList retainList = new ArrayList(collection.size());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Filtering collection with " + collection.size() + " elements");
            }
            for (Object filterObject : (Collection)filterTarget) {
                rootObject.setFilterObject(filterObject);
                if (!ExpressionUtils.evaluateAsBoolean(filterExpression, ctx)) continue;
                retainList.add(filterObject);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Retaining elements: " + retainList);
            }
            collection.clear();
            collection.addAll(retainList);
            return filterTarget;
        }
        if (filterTarget.getClass().isArray()) {
            Object[] array = (Object[])filterTarget;
            ArrayList<Object> retainList = new ArrayList<Object>(array.length);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Filtering collection with " + array.length + " elements");
            }
            for (int i2 = 0; i2 < array.length; ++i2) {
                rootObject.setFilterObject(array[i2]);
                if (!ExpressionUtils.evaluateAsBoolean(filterExpression, ctx)) continue;
                retainList.add(array[i2]);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Retaining elements: " + retainList);
            }
            Object[] filtered = (Object[])Array.newInstance(filterTarget.getClass().getComponentType(), retainList.size());
            for (int i3 = 0; i3 < retainList.size(); ++i3) {
                filtered[i3] = retainList.get(i3);
            }
            return filtered;
        }
        throw new IllegalArgumentException("Filter target must be a collection or array type, but was " + filterTarget);
    }

    public ExpressionParser getExpressionParser() {
        return this.expressionParser;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public void setPermissionEvaluator(PermissionEvaluator permissionEvaluator) {
        this.permissionEvaluator = permissionEvaluator;
    }

    public void setTrustResolver(AuthenticationTrustResolver trustResolver) {
        this.trustResolver = trustResolver;
    }

    public void setReturnObject(Object returnObject, EvaluationContext ctx) {
        ((MethodSecurityExpressionRoot)ctx.getRootObject().getValue()).setReturnObject(returnObject);
    }

    public void setRoleHierarchy(RoleHierarchy roleHierarchy) {
        this.roleHierarchy = roleHierarchy;
    }
}

