/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.expression.method;

import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParseException;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.PostInvocationExpressionAttribute;
import org.springframework.security.access.expression.method.PreInvocationExpressionAttribute;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.access.prepost.PostInvocationAttribute;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PreFilter;
import org.springframework.security.access.prepost.PreInvocationAttribute;
import org.springframework.security.access.prepost.PrePostInvocationAttributeFactory;

public class ExpressionBasedAnnotationAttributeFactory
implements PrePostInvocationAttributeFactory {
    private ExpressionParser parser;

    public ExpressionBasedAnnotationAttributeFactory(MethodSecurityExpressionHandler handler) {
        this.parser = handler.getExpressionParser();
    }

    public PreInvocationAttribute createPreInvocationAttribute(PreFilter preFilter, PreAuthorize preAuthorize) {
        try {
            Expression preAuthorizeExpression = preAuthorize == null ? this.parser.parseExpression("permitAll") : this.parser.parseExpression(preAuthorize.value());
            Expression preFilterExpression = preFilter == null ? null : this.parser.parseExpression(preFilter.value());
            String filterObject = preFilter == null ? null : preFilter.filterTarget();
            return new PreInvocationExpressionAttribute(preFilterExpression, filterObject, preAuthorizeExpression);
        }
        catch (ParseException e2) {
            throw new IllegalArgumentException("Failed to parse expression '" + e2.getExpressionString() + "'", e2);
        }
    }

    public PostInvocationAttribute createPostInvocationAttribute(PostFilter postFilter, PostAuthorize postAuthorize) {
        try {
            Expression postFilterExpression;
            Expression postAuthorizeExpression = postAuthorize == null ? null : this.parser.parseExpression(postAuthorize.value());
            Expression expression = postFilterExpression = postFilter == null ? null : this.parser.parseExpression(postFilter.value());
            if (postFilterExpression != null || postAuthorizeExpression != null) {
                return new PostInvocationExpressionAttribute(postFilterExpression, postAuthorizeExpression);
            }
        }
        catch (ParseException e2) {
            throw new IllegalArgumentException("Failed to parse expression '" + e2.getExpressionString() + "'", e2);
        }
        return null;
    }
}

