/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.vote;

import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.CodeSignature;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.AuthorizationServiceException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAclVoter
implements AccessDecisionVoter {
    private Class<?> processDomainObjectClass;

    protected Object getDomainObjectInstance(Object secureObject) {
        Object[] args;
        Class<?>[] params;
        if (secureObject instanceof MethodInvocation) {
            MethodInvocation invocation = (MethodInvocation)secureObject;
            params = invocation.getMethod().getParameterTypes();
            args = invocation.getArguments();
        } else {
            JoinPoint jp = (JoinPoint)secureObject;
            params = ((CodeSignature)jp.getStaticPart().getSignature()).getParameterTypes();
            args = jp.getArgs();
        }
        for (int i2 = 0; i2 < params.length; ++i2) {
            if (!this.processDomainObjectClass.isAssignableFrom(params[i2])) continue;
            return args[i2];
        }
        throw new AuthorizationServiceException("Secure object: " + secureObject + " did not provide any argument of type: " + this.processDomainObjectClass);
    }

    public Class<?> getProcessDomainObjectClass() {
        return this.processDomainObjectClass;
    }

    public void setProcessDomainObjectClass(Class<?> processDomainObjectClass) {
        Assert.notNull(processDomainObjectClass, "processDomainObjectClass cannot be set to null");
        this.processDomainObjectClass = processDomainObjectClass;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        if (MethodInvocation.class.isAssignableFrom(clazz)) {
            return true;
        }
        return JoinPoint.class.isAssignableFrom(clazz);
    }
}

