/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.util;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.security.util.SimpleMethodInvocation;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodInvocationUtils {
    private MethodInvocationUtils() {
    }

    public static MethodInvocation create(Object object, String methodName, Object ... args) {
        Advised a2;
        Assert.notNull(object, "Object required");
        Class[] classArgs = null;
        if (args != null) {
            classArgs = new Class[args.length];
            for (int i2 = 0; i2 < args.length; ++i2) {
                classArgs[i2] = args[i2].getClass();
            }
        }
        Class target = AopUtils.getTargetClass(object);
        if (object instanceof Advised && !(a2 = (Advised)object).isProxyTargetClass()) {
            Class[] possibleInterfaces = a2.getProxiedInterfaces();
            for (int i3 = 0; i3 < possibleInterfaces.length; ++i3) {
                try {
                    possibleInterfaces[i3].getMethod(methodName, classArgs);
                    target = possibleInterfaces[i3];
                    break;
                }
                catch (Exception tryTheNextOne) {
                    continue;
                }
            }
        }
        return MethodInvocationUtils.createFromClass(object, target, methodName, classArgs, args);
    }

    public static MethodInvocation createFromClass(Class<?> clazz, String methodName) {
        MethodInvocation mi = MethodInvocationUtils.createFromClass(null, clazz, methodName, null, null);
        if (mi == null) {
            for (Method m2 : clazz.getDeclaredMethods()) {
                if (!m2.getName().equals(methodName)) continue;
                if (mi != null) {
                    throw new IllegalArgumentException("The class " + clazz + " has more than one method named" + " '" + methodName + "'");
                }
                mi = new SimpleMethodInvocation(null, m2, new Object[0]);
            }
        }
        return mi;
    }

    public static MethodInvocation createFromClass(Object targetObject, Class<?> clazz, String methodName, Class<?>[] classArgs, Object[] args) {
        Method method;
        Assert.notNull(clazz, "Class required");
        Assert.hasText(methodName, "MethodName required");
        try {
            method = clazz.getMethod(methodName, classArgs);
        }
        catch (NoSuchMethodException e2) {
            return null;
        }
        return new SimpleMethodInvocation(targetObject, method, args);
    }
}

