/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventConsumer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.AbstractStaxContentHandler;
import org.springframework.util.xml.SimpleNamespaceContext;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StaxEventContentHandler
extends AbstractStaxContentHandler {
    private final XMLEventFactory eventFactory;
    private final XMLEventConsumer eventConsumer;

    StaxEventContentHandler(XMLEventConsumer consumer) {
        Assert.notNull(consumer, "'consumer' must not be null");
        this.eventFactory = XMLEventFactory.newInstance();
        this.eventConsumer = consumer;
    }

    StaxEventContentHandler(XMLEventConsumer consumer, XMLEventFactory factory) {
        this.eventFactory = factory;
        this.eventConsumer = consumer;
    }

    @Override
    public void setDocumentLocator(final Locator locator) {
        if (locator != null) {
            this.eventFactory.setLocation(new Location(){

                public int getLineNumber() {
                    return locator.getLineNumber();
                }

                public int getColumnNumber() {
                    return locator.getColumnNumber();
                }

                public int getCharacterOffset() {
                    return -1;
                }

                public String getPublicId() {
                    return locator.getPublicId();
                }

                public String getSystemId() {
                    return locator.getSystemId();
                }
            });
        }
    }

    @Override
    protected void startDocumentInternal() throws XMLStreamException {
        this.consumeEvent(this.eventFactory.createStartDocument());
    }

    @Override
    protected void endDocumentInternal() throws XMLStreamException {
        this.consumeEvent(this.eventFactory.createEndDocument());
    }

    @Override
    protected void startElementInternal(QName name, Attributes atts, SimpleNamespaceContext namespaceContext) throws XMLStreamException {
        List<Attribute> attributes = this.getAttributes(atts);
        List<Namespace> namespaces = this.createNamespaces(namespaceContext);
        this.consumeEvent(this.eventFactory.createStartElement(name, attributes.iterator(), namespaces != null ? namespaces.iterator() : null));
    }

    @Override
    protected void endElementInternal(QName name, SimpleNamespaceContext namespaceContext) throws XMLStreamException {
        List<Namespace> namespaces = this.createNamespaces(namespaceContext);
        this.consumeEvent(this.eventFactory.createEndElement(name, namespaces != null ? namespaces.iterator() : null));
    }

    @Override
    protected void charactersInternal(char[] ch, int start, int length) throws XMLStreamException {
        this.consumeEvent(this.eventFactory.createCharacters(new String(ch, start, length)));
    }

    @Override
    protected void ignorableWhitespaceInternal(char[] ch, int start, int length) throws XMLStreamException {
        this.consumeEvent(this.eventFactory.createIgnorableSpace(new String(ch, start, length)));
    }

    @Override
    protected void processingInstructionInternal(String target, String data) throws XMLStreamException {
        this.consumeEvent(this.eventFactory.createProcessingInstruction(target, data));
    }

    private void consumeEvent(XMLEvent event) throws XMLStreamException {
        this.eventConsumer.add(event);
    }

    private List<Namespace> createNamespaces(SimpleNamespaceContext namespaceContext) {
        if (namespaceContext == null) {
            return null;
        }
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        String defaultNamespaceUri = namespaceContext.getNamespaceURI("");
        if (StringUtils.hasLength(defaultNamespaceUri)) {
            namespaces.add(this.eventFactory.createNamespace(defaultNamespaceUri));
        }
        Iterator<String> iterator = namespaceContext.getBoundPrefixes();
        while (iterator.hasNext()) {
            String prefix = iterator.next();
            String namespaceUri = namespaceContext.getNamespaceURI(prefix);
            namespaces.add(this.eventFactory.createNamespace(prefix, namespaceUri));
        }
        return namespaces;
    }

    private List<Attribute> getAttributes(Attributes attributes) {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        int i2 = 0;
        while (i2 < attributes.getLength()) {
            QName name = this.toQName(attributes.getURI(i2), attributes.getQName(i2));
            if (!"xmlns".equals(name.getLocalPart()) && !"xmlns".equals(name.getPrefix())) {
                list.add(this.eventFactory.createAttribute(name, attributes.getValue(i2)));
            }
            ++i2;
        }
        return list;
    }

    @Override
    protected void skippedEntityInternal(String name) throws XMLStreamException {
    }
}

