/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.io.BufferedReader;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.springframework.util.StringUtils;

public class XmlValidationModeDetector {
    public static final int VALIDATION_NONE = 0;
    public static final int VALIDATION_AUTO = 1;
    public static final int VALIDATION_DTD = 2;
    public static final int VALIDATION_XSD = 3;
    private static final String DOCTYPE = "DOCTYPE";
    private static final String START_COMMENT = "<!--";
    private static final String END_COMMENT = "-->";
    private boolean inComment;

    public int detectValidationMode(InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String content;
            boolean isDtdValidated = false;
            while ((content = reader.readLine()) != null) {
                content = this.consumeCommentTokens(content);
                if (this.inComment || !StringUtils.hasText(content)) continue;
                if (this.hasDoctype(content)) {
                    isDtdValidated = true;
                    break;
                }
                if (this.hasOpeningTag(content)) break;
            }
            int n2 = isDtdValidated ? 2 : 3;
            return n2;
        }
        catch (CharConversionException charConversionException) {
            return 1;
        }
        finally {
            reader.close();
        }
    }

    private boolean hasDoctype(String content) {
        return content.indexOf(DOCTYPE) > -1;
    }

    private boolean hasOpeningTag(String content) {
        if (this.inComment) {
            return false;
        }
        int openTagIndex = content.indexOf(60);
        return openTagIndex > -1 && content.length() > openTagIndex && Character.isLetter(content.charAt(openTagIndex + 1));
    }

    /*
     * Unable to fully structure code
     */
    private String consumeCommentTokens(String line) {
        if (line.indexOf("<!--") != -1 || line.indexOf("-->") != -1) ** GOTO lbl5
        return line;
lbl-1000:
        // 1 sources

        {
            if (this.inComment || line.trim().startsWith("<!--")) continue;
            return line;
lbl5:
            // 2 sources

            ** while ((line = this.consume((String)line)) != null)
        }
lbl6:
        // 1 sources

        return line;
    }

    private String consume(String line) {
        int index = this.inComment ? this.endComment(line) : this.startComment(line);
        return index == -1 ? null : line.substring(index);
    }

    private int startComment(String line) {
        return this.commentToken(line, START_COMMENT, true);
    }

    private int endComment(String line) {
        return this.commentToken(line, END_COMMENT, false);
    }

    private int commentToken(String line, String token, boolean inCommentIfPresent) {
        int index = line.indexOf(token);
        if (index > -1) {
            this.inComment = inCommentIfPresent;
        }
        return index == -1 ? index : index + token.length();
    }
}

