/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.format.support.FormattingConversionServiceFactoryBean;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.feed.AtomFeedHttpMessageConverter;
import org.springframework.http.converter.feed.RssChannelHttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.http.converter.xml.XmlAwareFormHttpMessageConverter;
import org.springframework.util.ClassUtils;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.servlet.handler.ConversionServiceExposingInterceptor;
import org.springframework.web.servlet.handler.MappedInterceptor;
import org.springframework.web.servlet.mvc.annotation.AnnotationMethodHandlerAdapter;
import org.springframework.web.servlet.mvc.annotation.DefaultAnnotationHandlerMapping;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnnotationDrivenBeanDefinitionParser
implements BeanDefinitionParser {
    private static final boolean jsr303Present = ClassUtils.isPresent("javax.validation.Validator", AnnotationDrivenBeanDefinitionParser.class.getClassLoader());
    private static final boolean jaxb2Present = ClassUtils.isPresent("javax.xml.bind.Binder", AnnotationDrivenBeanDefinitionParser.class.getClassLoader());
    private static final boolean jacksonPresent = ClassUtils.isPresent("org.codehaus.jackson.map.ObjectMapper", AnnotationDrivenBeanDefinitionParser.class.getClassLoader()) && ClassUtils.isPresent("org.codehaus.jackson.JsonGenerator", AnnotationDrivenBeanDefinitionParser.class.getClassLoader());
    private static boolean romePresent = ClassUtils.isPresent("com.sun.syndication.feed.WireFeed", AnnotationDrivenBeanDefinitionParser.class.getClassLoader());

    AnnotationDrivenBeanDefinitionParser() {
    }

    @Override
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Object source = parserContext.extractSource(element);
        CompositeComponentDefinition compDefinition = new CompositeComponentDefinition(element.getTagName(), source);
        parserContext.pushContainingComponent(compDefinition);
        RootBeanDefinition annMappingDef = new RootBeanDefinition(DefaultAnnotationHandlerMapping.class);
        annMappingDef.setSource(source);
        annMappingDef.setRole(2);
        annMappingDef.getPropertyValues().add("order", 0);
        String annMappingName = parserContext.getReaderContext().registerWithGeneratedName(annMappingDef);
        RuntimeBeanReference conversionService = this.getConversionService(element, source, parserContext);
        RuntimeBeanReference validator = this.getValidator(element, source, parserContext);
        RootBeanDefinition bindingDef = new RootBeanDefinition(ConfigurableWebBindingInitializer.class);
        bindingDef.setSource(source);
        bindingDef.setRole(2);
        bindingDef.getPropertyValues().add("conversionService", conversionService);
        bindingDef.getPropertyValues().add("validator", validator);
        RootBeanDefinition annAdapterDef = new RootBeanDefinition(AnnotationMethodHandlerAdapter.class);
        annAdapterDef.setSource(source);
        annAdapterDef.setRole(2);
        annAdapterDef.getPropertyValues().add("webBindingInitializer", bindingDef);
        annAdapterDef.getPropertyValues().add("messageConverters", this.getMessageConverters(source));
        String annAdapterName = parserContext.getReaderContext().registerWithGeneratedName(annAdapterDef);
        RootBeanDefinition csInterceptorDef = new RootBeanDefinition(ConversionServiceExposingInterceptor.class);
        csInterceptorDef.setSource(source);
        csInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(0, conversionService);
        RootBeanDefinition mappedCsInterceptorDef = new RootBeanDefinition(MappedInterceptor.class);
        mappedCsInterceptorDef.setSource(source);
        mappedCsInterceptorDef.setRole(2);
        mappedCsInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)null);
        mappedCsInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(1, csInterceptorDef);
        String mappedInterceptorName = parserContext.getReaderContext().registerWithGeneratedName(mappedCsInterceptorDef);
        parserContext.registerComponent(new BeanComponentDefinition(annMappingDef, annMappingName));
        parserContext.registerComponent(new BeanComponentDefinition(annAdapterDef, annAdapterName));
        parserContext.registerComponent(new BeanComponentDefinition(mappedCsInterceptorDef, mappedInterceptorName));
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    private RuntimeBeanReference getConversionService(Element element, Object source, ParserContext parserContext) {
        if (element.hasAttribute("conversion-service")) {
            return new RuntimeBeanReference(element.getAttribute("conversion-service"));
        }
        RootBeanDefinition conversionDef = new RootBeanDefinition(FormattingConversionServiceFactoryBean.class);
        conversionDef.setSource(source);
        conversionDef.setRole(2);
        String conversionName = parserContext.getReaderContext().registerWithGeneratedName(conversionDef);
        parserContext.registerComponent(new BeanComponentDefinition(conversionDef, conversionName));
        return new RuntimeBeanReference(conversionName);
    }

    private RuntimeBeanReference getValidator(Element element, Object source, ParserContext parserContext) {
        if (element.hasAttribute("validator")) {
            return new RuntimeBeanReference(element.getAttribute("validator"));
        }
        if (jsr303Present) {
            RootBeanDefinition validatorDef = new RootBeanDefinition(LocalValidatorFactoryBean.class);
            validatorDef.setSource(source);
            validatorDef.setRole(2);
            String validatorName = parserContext.getReaderContext().registerWithGeneratedName(validatorDef);
            parserContext.registerComponent(new BeanComponentDefinition(validatorDef, validatorName));
            return new RuntimeBeanReference(validatorName);
        }
        return null;
    }

    private ManagedList<RootBeanDefinition> getMessageConverters(Object source) {
        ManagedList<RootBeanDefinition> messageConverters = new ManagedList<RootBeanDefinition>();
        messageConverters.setSource(source);
        messageConverters.add(this.createConverterBeanDefinition(ByteArrayHttpMessageConverter.class, source));
        RootBeanDefinition stringConverterDef = this.createConverterBeanDefinition(StringHttpMessageConverter.class, source);
        stringConverterDef.getPropertyValues().add("writeAcceptCharset", false);
        messageConverters.add(stringConverterDef);
        messageConverters.add(this.createConverterBeanDefinition(ResourceHttpMessageConverter.class, source));
        messageConverters.add(this.createConverterBeanDefinition(SourceHttpMessageConverter.class, source));
        messageConverters.add(this.createConverterBeanDefinition(XmlAwareFormHttpMessageConverter.class, source));
        if (jaxb2Present) {
            messageConverters.add(this.createConverterBeanDefinition(Jaxb2RootElementHttpMessageConverter.class, source));
        }
        if (jacksonPresent) {
            messageConverters.add(this.createConverterBeanDefinition(MappingJacksonHttpMessageConverter.class, source));
        }
        if (romePresent) {
            messageConverters.add(this.createConverterBeanDefinition(AtomFeedHttpMessageConverter.class, source));
            messageConverters.add(this.createConverterBeanDefinition(RssChannelHttpMessageConverter.class, source));
        }
        return messageConverters;
    }

    private RootBeanDefinition createConverterBeanDefinition(Class<? extends HttpMessageConverter> converterClass, Object source) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(converterClass);
        beanDefinition.setSource(source);
        beanDefinition.setRole(2);
        return beanDefinition;
    }
}

