/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config;

import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.config.AbstractHttpRequestHandlerBeanDefinitionParser;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import org.w3c.dom.Element;

class ResourcesBeanDefinitionParser
extends AbstractHttpRequestHandlerBeanDefinitionParser
implements BeanDefinitionParser {
    ResourcesBeanDefinitionParser() {
    }

    public void doParse(Element element, ParserContext parserContext) {
        Object source = parserContext.extractSource(element);
        this.registerResourceMappings(parserContext, element, source);
    }

    private void registerResourceMappings(ParserContext parserContext, Element element, Object source) {
        String resourceHandlerName = this.registerResourceHandler(parserContext, element, source);
        if (resourceHandlerName == null) {
            return;
        }
        ManagedMap<String, String> urlMap = new ManagedMap<String, String>();
        String resourceRequestPath = element.getAttribute("mapping");
        if (!StringUtils.hasText(resourceRequestPath)) {
            parserContext.getReaderContext().error("The 'mapping' attribute is required.", parserContext.extractSource(element));
            return;
        }
        urlMap.put(resourceRequestPath, resourceHandlerName);
        RootBeanDefinition handlerMappingDef = new RootBeanDefinition(SimpleUrlHandlerMapping.class);
        handlerMappingDef.setSource(source);
        handlerMappingDef.setRole(2);
        handlerMappingDef.getPropertyValues().add("urlMap", urlMap);
        String order = element.getAttribute("order");
        handlerMappingDef.getPropertyValues().add("order", StringUtils.hasText(order) ? order : Integer.valueOf(0x7FFFFFFE));
        String beanName = parserContext.getReaderContext().generateBeanName(handlerMappingDef);
        parserContext.getRegistry().registerBeanDefinition(beanName, handlerMappingDef);
        parserContext.registerComponent(new BeanComponentDefinition(handlerMappingDef, beanName));
    }

    private String registerResourceHandler(ParserContext parserContext, Element element, Object source) {
        String locationAttr = element.getAttribute("location");
        if (!StringUtils.hasText(locationAttr)) {
            parserContext.getReaderContext().error("The 'location' attribute is required.", parserContext.extractSource(element));
            return null;
        }
        RootBeanDefinition resourceHandlerDef = new RootBeanDefinition(ResourceHttpRequestHandler.class);
        resourceHandlerDef.setSource(source);
        resourceHandlerDef.setRole(2);
        resourceHandlerDef.getPropertyValues().add("locations", StringUtils.commaDelimitedListToStringArray(locationAttr));
        String cacheSeconds = element.getAttribute("cache-period");
        if (StringUtils.hasText(cacheSeconds)) {
            resourceHandlerDef.getPropertyValues().add("cacheSeconds", cacheSeconds);
        }
        String beanName = parserContext.getReaderContext().generateBeanName(resourceHandlerDef);
        parserContext.getRegistry().registerBeanDefinition(beanName, resourceHandlerDef);
        parserContext.registerComponent(new BeanComponentDefinition(resourceHandlerDef, beanName));
        return beanName;
    }
}

