/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.support.WebContentGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceHttpRequestHandler
extends WebContentGenerator
implements HttpRequestHandler {
    private List<Resource> locations;

    public ResourceHttpRequestHandler() {
        super("GET", "HEAD");
    }

    public void setLocations(List<Resource> locations) {
        Assert.notEmpty(locations, "Location list must not be empty");
        this.locations = locations;
    }

    @Override
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.checkAndPrepare(request, response, true);
        Resource resource = this.getResource(request);
        if (resource == null) {
            this.logger.debug("No matching resource found - returning 404");
            response.sendError(404);
            return;
        }
        MediaType mediaType = this.getMediaType(resource);
        if (mediaType != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Determined media type [" + mediaType + "] for " + resource);
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No media type found for " + resource + " - returning 404");
            }
            response.sendError(404);
            return;
        }
        this.setHeaders(response, resource, mediaType);
        if (new ServletWebRequest(request, response).checkNotModified(resource.lastModified())) {
            this.logger.debug("Resource not modified - returning 304");
            return;
        }
        if ("HEAD".equals(request.getMethod())) {
            this.logger.trace("HEAD request - skipping content");
            return;
        }
        this.writeContent(response, resource);
    }

    protected Resource getResource(HttpServletRequest request) {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        if (path == null) {
            throw new IllegalStateException("Required request attribute '" + HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE + "' is not set");
        }
        if (!StringUtils.hasText(path) || path.contains("WEB-INF") || path.contains("META-INF")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Ignoring invalid resource path [" + path + "]");
            }
            return null;
        }
        for (Resource location : this.locations) {
            try {
                Resource resource;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Trying relative path [" + path + "] against base location: " + location);
                }
                if ((resource = location.createRelative(path)).exists() && resource.isReadable()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Found matching resource: " + resource);
                    }
                    return resource;
                }
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace("Relative resource doesn't exist or isn't readable: " + resource);
            }
            catch (IOException ex) {
                this.logger.debug("Failed to create relative resource - trying next resource location", ex);
            }
        }
        return null;
    }

    protected MediaType getMediaType(Resource resource) {
        String mimeType = this.getServletContext().getMimeType(resource.getFilename());
        return StringUtils.hasText(mimeType) ? MediaType.parseMediaType(mimeType) : null;
    }

    protected void setHeaders(HttpServletResponse response, Resource resource, MediaType mediaType) throws IOException {
        long length = resource.contentLength();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Resource content too long (beyond Integer.MAX_VALUE): " + resource);
        }
        response.setContentLength((int)length);
        response.setContentType(mediaType.toString());
    }

    protected void writeContent(HttpServletResponse response, Resource resource) throws IOException {
        FileCopyUtils.copy(resource.getInputStream(), (OutputStream)response.getOutputStream());
    }
}

